/*
 * Decompiled with CFR 0.152.
 */
package one.jfr;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.event.AllocationSample;
import one.jfr.event.ContendedLock;
import one.jfr.event.Event;
import one.jfr.event.EventAggregator;
import one.jfr.event.ExecutionSample;
import one.jfr.event.LiveObject;
import org.apache.skywalking.oap.server.library.jfr.type.Classifier;
import org.apache.skywalking.oap.server.library.jfr.type.JFREventType;

public abstract class JFRConverter
extends Classifier {
    protected final JfrReader jfr;
    protected Dictionary<String> methodNames;

    public JFRConverter(JfrReader jfr) {
        this.jfr = jfr;
    }

    public void convert() throws IOException {
        this.jfr.stopAtNewChunk = true;
        while (!this.jfr.eof()) {
            this.methodNames = new Dictionary();
            this.convertChunk();
        }
    }

    protected abstract void convertChunk() throws IOException;

    protected Map<JFREventType, EventAggregator> collectMultiEvents() throws IOException {
        Event event;
        HashMap<JFREventType, EventAggregator> event2aggMap = new HashMap<JFREventType, EventAggregator>();
        while ((event = this.jfr.readEvent()) != null) {
            EventAggregator agg = null;
            if (event instanceof ExecutionSample) {
                agg = event2aggMap.computeIfAbsent(JFREventType.EXECUTION_SAMPLE, JFRConverter::getEventAggregator);
            } else if (event instanceof AllocationSample) {
                AllocationSample allocationSample = (AllocationSample)event;
                agg = allocationSample.tlabSize != 0L ? event2aggMap.computeIfAbsent(JFREventType.OBJECT_ALLOCATION_IN_NEW_TLAB, JFRConverter::getEventAggregator) : event2aggMap.computeIfAbsent(JFREventType.OBJECT_ALLOCATION_OUTSIDE_TLAB, JFRConverter::getEventAggregator);
            } else if (event instanceof ContendedLock) {
                agg = event2aggMap.computeIfAbsent(JFREventType.LOCK, JFRConverter::getEventAggregator);
            } else if (event instanceof LiveObject) {
                agg = event2aggMap.computeIfAbsent(JFREventType.PROFILER_LIVE_OBJECT, JFRConverter::getEventAggregator);
            }
            if (agg == null) continue;
            agg.collect(event);
        }
        return event2aggMap;
    }

    private static EventAggregator getEventAggregator(JFREventType jfrEventType) {
        switch (jfrEventType) {
            case EXECUTION_SAMPLE: {
                return new EventAggregator(true, false);
            }
            case PROFILER_LIVE_OBJECT: 
            case OBJECT_ALLOCATION_IN_NEW_TLAB: 
            case OBJECT_ALLOCATION_OUTSIDE_TLAB: 
            case LOCK: 
            case JAVA_MONITOR_ENTER: 
            case THREAD_PARK: {
                return new EventAggregator(true, true);
            }
        }
        throw new IllegalStateException("EventAggregator is not support event type : " + jfrEventType);
    }

    @Override
    public String getMethodName(long methodId, byte methodType) {
        String result = (String)this.methodNames.get(methodId);
        if (result == null) {
            result = this.resolveMethodName(methodId, methodType);
            this.methodNames.put(methodId, (Object)result);
        }
        return result;
    }

    private String resolveMethodName(long methodId, byte methodType) {
        MethodRef method = (MethodRef)this.jfr.methods.get(methodId);
        if (method == null) {
            return "unknown";
        }
        ClassRef cls = (ClassRef)this.jfr.classes.get(method.cls);
        byte[] className = (byte[])this.jfr.symbols.get(cls.name);
        byte[] methodName = (byte[])this.jfr.symbols.get(method.name);
        if (className == null || className.length == 0 || this.isNativeFrame(methodType)) {
            return new String(methodName, StandardCharsets.UTF_8);
        }
        String classStr = this.toJavaClassName(className, 0);
        if (methodName == null || methodName.length == 0) {
            return classStr;
        }
        String methodStr = new String(methodName, StandardCharsets.UTF_8);
        return classStr + "." + methodStr;
    }

    protected String getClassName(long classId) {
        ClassRef cls = (ClassRef)this.jfr.classes.get(classId);
        if (cls == null) {
            return "null";
        }
        byte[] className = (byte[])this.jfr.symbols.get(cls.name);
        int arrayDepth = 0;
        while (className[arrayDepth] == 91) {
            ++arrayDepth;
        }
        String name = this.toJavaClassName(className, arrayDepth);
        while (arrayDepth-- > 0) {
            name = name.concat("[]");
        }
        return name;
    }

    protected String getThreadName(int tid) {
        String threadName = (String)this.jfr.threads.get((long)tid);
        return threadName == null ? "[tid=" + tid + "]" : (threadName.startsWith("[tid=") ? threadName : "[" + threadName + " tid=" + tid + "]");
    }

    protected String toJavaClassName(byte[] symbol, int start) {
        int end = symbol.length;
        if (start > 0) {
            switch (symbol[start]) {
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 90: {
                    return "boolean";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 76: {
                    ++start;
                    --end;
                }
            }
        }
        for (int i = end - 2; i > start; --i) {
            if (symbol[i] != 47 && symbol[i] != 46) continue;
            if (symbol[i + 1] < 48 || symbol[i + 1] > 57) break;
            end = i;
            if (i <= start + 19 || symbol[i - 19] != 43 || symbol[i - 18] != 48) break;
            end = i - 19;
            break;
        }
        String s = new String(symbol, start, end - start, StandardCharsets.UTF_8);
        return s.replace('/', '.');
    }

    protected boolean isNativeFrame(byte methodType) {
        return methodType == 3 && this.jfr.getEnumValue("jdk.types.FrameType", 5) != null || methodType == 4 || methodType == 5;
    }
}

