/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.dsl.spec.filter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.AbstractSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.extractor.ExtractorSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.parser.JsonParserSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.parser.TextParserSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.parser.YamlParserSpec;
import org.apache.skywalking.oap.log.analyzer.dsl.spec.sink.SinkSpec;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogSinkListenerFactory;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.RecordSinkListener;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.TrafficSinkListener;
import org.apache.skywalking.oap.server.core.source.Log;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSpec
extends AbstractSpec {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSpec.class);
    private final List<LogSinkListenerFactory> sinkListenerFactories;
    private final TextParserSpec textParser;
    private final JsonParserSpec jsonParser;
    private final YamlParserSpec yamlParser;
    private final ExtractorSpec extractor;
    private final SinkSpec sink;
    private final TypeReference<Map<String, Object>> parsedType = new TypeReference<Map<String, Object>>(){};

    public FilterSpec(ModuleManager moduleManager, LogAnalyzerModuleConfig moduleConfig) throws ModuleStartException {
        super(moduleManager, moduleConfig);
        this.sinkListenerFactories = Arrays.asList(new RecordSinkListener.Factory(this.moduleManager(), this.moduleConfig()), new TrafficSinkListener.Factory(this.moduleManager(), this.moduleConfig()));
        this.textParser = new TextParserSpec(this.moduleManager(), this.moduleConfig());
        this.jsonParser = new JsonParserSpec(this.moduleManager(), this.moduleConfig());
        this.yamlParser = new YamlParserSpec(this.moduleManager(), this.moduleConfig());
        this.extractor = new ExtractorSpec(this.moduleManager(), this.moduleConfig());
        this.sink = new SinkSpec(this.moduleManager(), this.moduleConfig());
    }

    public void text(@DelegatesTo(value=TextParserSpec.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        cl.setDelegate((Object)this.textParser);
        cl.call();
    }

    public void json(@DelegatesTo(value=JsonParserSpec.class) Closure<?> cl) {
        block3: {
            if (((Binding)((Object)BINDING.get())).shouldAbort()) {
                return;
            }
            cl.setDelegate((Object)this.jsonParser);
            cl.call();
            LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
            try {
                Map parsed = (Map)this.jsonParser.create().readValue(logData.getBody().getJson().getJson(), this.parsedType);
                ((Binding)((Object)BINDING.get())).parsed(parsed);
            }
            catch (Exception e) {
                if (!this.jsonParser.abortOnFailure()) break block3;
                ((Binding)((Object)BINDING.get())).abort();
            }
        }
    }

    public void yaml(@DelegatesTo(value=YamlParserSpec.class) Closure<?> cl) {
        block3: {
            if (((Binding)((Object)BINDING.get())).shouldAbort()) {
                return;
            }
            cl.setDelegate((Object)this.yamlParser);
            cl.call();
            LogData.Builder logData = ((Binding)((Object)BINDING.get())).log();
            try {
                Map parsed = (Map)this.yamlParser.create().load(logData.getBody().getYaml().getYaml());
                ((Binding)((Object)BINDING.get())).parsed(parsed);
            }
            catch (Exception e) {
                if (!this.yamlParser.abortOnFailure()) break block3;
                ((Binding)((Object)BINDING.get())).abort();
            }
        }
    }

    public void extractor(@DelegatesTo(value=ExtractorSpec.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        cl.setDelegate((Object)this.extractor);
        cl.call();
    }

    public void sink(@DelegatesTo(value=SinkSpec.class) Closure<?> cl) {
        if (((Binding)((Object)BINDING.get())).shouldAbort()) {
            return;
        }
        cl.setDelegate((Object)this.sink);
        cl.call();
        Binding b = (Binding)((Object)BINDING.get());
        LogData.Builder logData = b.log();
        Message extraLog = b.extraLog();
        if (!b.shouldSave()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Log is dropped: {}", (Object)TextFormat.shortDebugString((MessageOrBuilder)logData));
            }
            return;
        }
        Optional<AtomicReference<Log>> container = ((Binding)((Object)BINDING.get())).logContainer();
        if (container.isPresent()) {
            this.sinkListenerFactories.stream().map(LogSinkListenerFactory::create).filter((? super T it) -> it instanceof RecordSinkListener).map(it -> it.parse(logData, extraLog)).map(it -> (RecordSinkListener)it).map(RecordSinkListener::getLog).findFirst().ifPresent(log -> ((AtomicReference)container.get()).set(log));
        } else {
            this.sinkListenerFactories.stream().map(LogSinkListenerFactory::create).forEach(it -> it.parse(logData, extraLog).build());
        }
    }

    public void filter(Closure<?> cl) {
        cl.call();
    }
}

