/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.loadbalancer;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.loadbalancer.AggregationWeightTransition;
import com.linecorp.armeria.common.loadbalancer.LinearWeightTransition;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@FunctionalInterface
@UnstableApi
public interface WeightTransition<T> {
    public static <T> WeightTransition<T> linear() {
        return LinearWeightTransition.INSTANCE;
    }

    public static <T> WeightTransition<T> aggression(double aggression, double minWeightPercent) {
        Preconditions.checkArgument(aggression > 0.0, "aggression: %s (expected: > 0.0)", (Object)aggression);
        Preconditions.checkArgument(minWeightPercent >= 0.0 && minWeightPercent <= 1.0, "minWeightPercent: %s (expected: >= 0.0, <= 1.0)", (Object)minWeightPercent);
        return new AggregationWeightTransition(aggression, minWeightPercent);
    }

    public int compute(T var1, int var2, int var3, int var4);
}

