/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.visitor;

import graphql.PublicApi;
import graphql.schema.GraphQLSchemaElement;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;

@PublicApi
public class GraphQLSchemaTraversalControl {
    private final GraphQLSchemaElement element;
    private final Control control;
    static final GraphQLSchemaTraversalControl CONTINUE = new GraphQLSchemaTraversalControl(Control.CONTINUE, null);
    static final GraphQLSchemaTraversalControl QUIT = new GraphQLSchemaTraversalControl(Control.QUIT, null);
    static final GraphQLSchemaTraversalControl DELETE = new GraphQLSchemaTraversalControl(Control.DELETE, null);

    GraphQLSchemaTraversalControl(Control control, GraphQLSchemaElement element) {
        this.element = element;
        this.control = control;
    }

    GraphQLSchemaElement getElement() {
        return this.element;
    }

    Control getControl() {
        return this.control;
    }

    boolean isAbortive() {
        return this.control == Control.QUIT;
    }

    boolean isMutative() {
        return this.control == Control.DELETE || this.control == Control.CHANGE || this.control == Control.INSERT_AFTER || this.control == Control.INSERT_BEFORE;
    }

    TraversalControl toTraversalControl(TraverserContext<GraphQLSchemaElement> context) {
        if (this.control == Control.CONTINUE || this.control == Control.QUIT) {
            return this.control.toTraversalControl();
        }
        if (this.control == Control.DELETE) {
            TreeTransformerUtil.deleteNode(context);
        }
        if (this.control == Control.CHANGE) {
            TreeTransformerUtil.changeNode(context, this.element);
        }
        if (this.control == Control.INSERT_AFTER) {
            TreeTransformerUtil.insertAfter(context, this.element);
        }
        if (this.control == Control.INSERT_BEFORE) {
            TreeTransformerUtil.insertAfter(context, this.element);
        }
        return TraversalControl.CONTINUE;
    }

    static enum Control {
        CONTINUE(TraversalControl.CONTINUE),
        QUIT(TraversalControl.QUIT),
        CHANGE(TraversalControl.CONTINUE),
        DELETE(TraversalControl.CONTINUE),
        INSERT_BEFORE(TraversalControl.CONTINUE),
        INSERT_AFTER(TraversalControl.CONTINUE);

        private final TraversalControl traversalControl;

        private Control(TraversalControl traversalControl) {
            this.traversalControl = traversalControl;
        }

        public TraversalControl toTraversalControl() {
            return this.traversalControl;
        }
    }
}

