/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.data.BufferedData;
import org.apache.skywalking.oap.server.core.analysis.topn.TopN;

public class LimitedSizeBufferedData<STORAGE_DATA extends TopN>
implements BufferedData<STORAGE_DATA> {
    private final HashMap<String, LinkedList<STORAGE_DATA>> data = new HashMap();
    private final int limitedSize;

    public LimitedSizeBufferedData(int limitedSize) {
        this.limitedSize = limitedSize;
    }

    @Override
    public void accept(STORAGE_DATA data) {
        String topGroupKey = ((TopN)data).getEntityId() + TimeBucket.getMinuteTimeBucket(((TopN)data).getTimestamp());
        LinkedList<Object> storageDataList = this.data.get(topGroupKey);
        if (storageDataList == null) {
            storageDataList = new LinkedList();
            this.data.put(topGroupKey, storageDataList);
        }
        if (storageDataList.size() < this.limitedSize) {
            storageDataList.add(data);
            return;
        }
        for (int i = 0; i < storageDataList.size(); ++i) {
            TopN storageData = (TopN)storageDataList.get(i);
            if (((TopN)data).compareTo(storageData) > 0) continue;
            if (i != 0) {
                storageDataList.add(i, data);
                storageDataList.removeFirst();
            }
            return;
        }
        storageDataList.addLast(data);
        storageDataList.removeFirst();
    }

    @Override
    public List<STORAGE_DATA> read() {
        try {
            ArrayList collection = new ArrayList();
            this.data.values().forEach(collection::addAll);
            ArrayList arrayList = collection;
            return arrayList;
        }
        finally {
            this.data.clear();
        }
    }
}

