/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.cache;

import com.google.common.primitives.Ints;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.cache.CacheDescriptor;
import com.orbitz.consul.cache.ConsulCache;
import com.orbitz.consul.config.CacheConfig;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class NodesCatalogCache
extends ConsulCache<String, Node> {
    private NodesCatalogCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds, ConsulCache.Scheduler callbackScheduler) {
        super(Node::getNode, (BigInteger index, ConsulResponseCallback<List<V>> callback) -> {
            NodesCatalogCache.checkWatch(catalogClient.getNetworkTimeoutConfig().getClientReadTimeoutMillis(), watchSeconds);
            catalogClient.getNodes(NodesCatalogCache.watchParams(index, watchSeconds, queryOptions), callback);
        }, catalogClient.getConfig().getCacheConfig(), catalogClient.getEventHandler(), new CacheDescriptor("catalog.nodes"), callbackScheduler);
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds, ScheduledExecutorService callbackExecutorService) {
        ConsulCache.Scheduler scheduler = NodesCatalogCache.createExternal(callbackExecutorService);
        return new NodesCatalogCache(catalogClient, queryOptions, watchSeconds, scheduler);
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient, QueryOptions queryOptions, int watchSeconds) {
        return new NodesCatalogCache(catalogClient, queryOptions, watchSeconds, NodesCatalogCache.createDefault());
    }

    public static NodesCatalogCache newCache(CatalogClient catalogClient) {
        CacheConfig cacheConfig = catalogClient.getConfig().getCacheConfig();
        int watchSeconds = Ints.checkedCast((long)cacheConfig.getWatchDuration().getSeconds());
        return NodesCatalogCache.newCache(catalogClient, QueryOptions.BLANK, watchSeconds);
    }
}

