/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Node;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Struct;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.FindCoordinatorResponse;

public class FindCoordinatorRequest
extends AbstractRequest {
    private final FindCoordinatorRequestData data;

    private FindCoordinatorRequest(FindCoordinatorRequestData data, short version) {
        super(ApiKeys.FIND_COORDINATOR, version);
        this.data = data;
    }

    public FindCoordinatorRequest(Struct struct, short version) {
        super(ApiKeys.FIND_COORDINATOR, version);
        this.data = new FindCoordinatorRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        FindCoordinatorResponseData response = new FindCoordinatorResponseData();
        if (this.version() >= 2) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        Errors error = Errors.forException(e);
        return FindCoordinatorResponse.prepareResponse(error, Node.noNode());
    }

    public static FindCoordinatorRequest parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorRequest(ApiKeys.FIND_COORDINATOR.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public FindCoordinatorRequestData data() {
        return this.data;
    }

    public static enum CoordinatorType {
        GROUP(0),
        TRANSACTION(1);

        final byte id;

        private CoordinatorType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static CoordinatorType forId(byte id) {
            switch (id) {
                case 0: {
                    return GROUP;
                }
                case 1: {
                    return TRANSACTION;
                }
            }
            throw new IllegalArgumentException("Unknown coordinator type received: " + id);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<FindCoordinatorRequest> {
        private final FindCoordinatorRequestData data;

        public Builder(FindCoordinatorRequestData data) {
            super(ApiKeys.FIND_COORDINATOR);
            this.data = data;
        }

        @Override
        public FindCoordinatorRequest build(short version) {
            if (version < 1 && this.data.keyType() == CoordinatorType.TRANSACTION.id()) {
                throw new UnsupportedVersionException("Cannot create a v" + version + " FindCoordinator request because we require features supported only in 2 or later.");
            }
            return new FindCoordinatorRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }

        public FindCoordinatorRequestData data() {
            return this.data;
        }
    }
}

