/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bnd.models;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.service.reporter.Reporter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelsScannerPlugin
implements AnalyzerPlugin,
Plugin {
    static final String MODELS_ANNOTATION_CLASS = "org.apache.sling.models.annotations.Model";
    static final String MODELS_PACKAGES_HEADER = "Sling-Model-Packages";
    static final String MODELS_CLASSES_HEADER = "Sling-Model-Classes";
    static final int MODELS_CLASSES_HEADER_MAXLENGTH = 60000;
    static final String PROPERTY_GENERATE_PACKAGES_HEADER = "generatePackagesHeader";
    private Reporter reporter;
    private Map<String, String> properties;

    public void setProperties(Map<String, String> map) throws Exception {
        this.properties = map;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Collection<String> classNames;
        if (analyzer.get(MODELS_PACKAGES_HEADER) == null && analyzer.get(MODELS_CLASSES_HEADER) == null && !(classNames = this.getClassesWithAnnotation(MODELS_ANNOTATION_CLASS, analyzer)).isEmpty()) {
            if (this.getBooleanProperty(PROPERTY_GENERATE_PACKAGES_HEADER)) {
                this.generatePackagesHeader(analyzer, classNames);
            } else {
                this.generateClassesHeader(analyzer, classNames);
            }
        }
        return false;
    }

    private void generateClassesHeader(Analyzer analyzer, Collection<String> classNames) {
        String classNameHeader = StringUtils.join(classNames, (String)",");
        if (classNameHeader.length() <= 60000) {
            analyzer.set(MODELS_CLASSES_HEADER, classNameHeader);
        } else {
            this.generatePackagesHeader(analyzer, classNames);
        }
    }

    private void generatePackagesHeader(Analyzer analyzer, Collection<String> classNames) {
        TreeSet<String> packages = new TreeSet<String>();
        for (String className : classNames) {
            if (!StringUtils.contains((CharSequence)className, (CharSequence)".")) continue;
            packages.add(StringUtils.substringBeforeLast((String)className, (String)"."));
        }
        HashSet<String> packagesToRemove = new HashSet<String>();
        for (String packageName : packages) {
            if (!this.includesParentPackage(packages, packageName)) continue;
            packagesToRemove.add(packageName);
        }
        packages.removeAll(packagesToRemove);
        analyzer.set(MODELS_PACKAGES_HEADER, StringUtils.join(packages, (String)","));
    }

    private boolean includesParentPackage(Set<String> packages, String packageName) {
        if (StringUtils.contains((CharSequence)packageName, (CharSequence)".")) {
            String parentPackageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
            if (packages.contains(parentPackageName)) {
                return true;
            }
            return this.includesParentPackage(packages, parentPackageName);
        }
        return false;
    }

    private Collection<String> getClassesWithAnnotation(String annotationClassName, Analyzer analyzer) {
        TreeSet<String> classNames = new TreeSet<String>();
        Collection clazzes = analyzer.getClassspace().values();
        Instruction instruction = new Instruction(annotationClassName);
        try {
            for (Clazz clazz : clazzes) {
                if (!clazz.is(Clazz.QUERY.ANNOTATED, instruction, analyzer)) continue;
                classNames.add(clazz.getClassName().getFQN());
            }
        }
        catch (Exception ex) {
            this.reporter.exception((Throwable)ex, "Error querying for classes with annotation: " + annotationClassName, new Object[0]);
        }
        return classNames;
    }

    private boolean getBooleanProperty(String propertyName) {
        String value = this.properties != null ? this.properties.get(propertyName) : null;
        return BooleanUtils.toBoolean(value);
    }
}

