/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.insights;

public class Message {
    private STYLE style;
    private String text;

    public static Message danger(String text) {
        return new Message(text, STYLE.DANGER);
    }

    public static Message defaultMsg(String text) {
        return new Message(text, STYLE.DEFAULT);
    }

    public static Message success(String text) {
        return new Message(text, STYLE.SUCCESS);
    }

    public static Message warn(String text) {
        return new Message(text, STYLE.WARNING);
    }

    public Message(String text, STYLE style) {
        this.text = text;
        this.style = style;
    }

    public STYLE getStyle() {
        return this.style;
    }

    public String getStyleClass() {
        String styleClass = "";
        if (this.style != STYLE.DEFAULT) {
            styleClass = "is-" + this.style.toString().toLowerCase();
        }
        return styleClass;
    }

    public String getText() {
        return this.text;
    }

    public void setStyle(STYLE style) {
        this.style = style;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return "Message [style=" + (Object)((Object)this.style) + ", text=" + this.text + "]";
    }

    public static enum STYLE {
        DANGER,
        DEFAULT,
        SUCCESS,
        WARNING;

    }
}

