/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.cluster.voting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.cluster.voting.VotingView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VotingHelper {
    private static final Logger logger = LoggerFactory.getLogger(VotingHelper.class);

    public static List<VotingView> listOpenNonWinningVotings(ResourceResolver resourceResolver, Config config) {
        if (config == null) {
            logger.info("listOpenNonWinningVotings: config is null, bundle likely deactivated.");
            return new ArrayList<VotingView>();
        }
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.debug("listOpenNonWinningVotings: no ongoing votings parent resource found");
            return new ArrayList<VotingView>();
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        if (!it.hasNext()) {
            return result;
        }
        while (it.hasNext()) {
            String matchesLiveView;
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            try {
                matchesLiveView = c.matchesLiveView(config);
            }
            catch (Exception e) {
                logger.error("listOpenNonWinningVotings: could not compare voting with live view: " + e, (Throwable)e);
                continue;
            }
            boolean ongoingVoting = c.isOngoingVoting(config);
            boolean hasNoVotes = c.hasNoVotes();
            boolean isWinning = c.isWinning();
            if (matchesLiveView == null && ongoingVoting && !hasNoVotes && !isWinning) {
                if (logger.isDebugEnabled()) {
                    logger.debug("listOpenNonWinningVotings: found an open voting: " + aChild + ", properties=" + ResourceHelper.getPropertiesForLogging((Resource)aChild));
                }
                result.add(c);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("listOpenNonWinningVotings: a non-open voting: " + aChild + ", matches live: " + matchesLiveView + ", is ongoing: " + ongoingVoting + ", has no votes: " + hasNoVotes + ", is winning: " + isWinning + ", properties=" + ResourceHelper.getPropertiesForLogging((Resource)aChild));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listOpenNonWinningVotings: votings found: " + result.size());
        }
        return result;
    }

    public static List<VotingView> listTimedoutVotings(ResourceResolver resourceResolver, Config config) {
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.info("listTimedoutVotings: no ongoing votings parent resource found");
            return new ArrayList<VotingView>();
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        if (!it.hasNext()) {
            return result;
        }
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            if (!c.isTimedoutVoting(config)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("listTimedoutVotings: found a timed-out voting: " + aChild + ", properties=" + ResourceHelper.getPropertiesForLogging((Resource)aChild));
            }
            result.add(c);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listTimedoutVotings: votings found: " + result.size());
        }
        return result;
    }

    public static VotingView getWinningVoting(ResourceResolver resourceResolver, Config config) {
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.debug("getWinningVoting: no ongoing votings parent resource found");
            return null;
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            boolean ongoing = c.isOngoingVoting(config);
            boolean winning = c.isWinning();
            if (ongoing && winning) {
                if (logger.isDebugEnabled()) {
                    logger.debug("getWinningVoting: a winning voting: " + aChild);
                }
                result.add(c);
                continue;
            }
            logger.debug("getWinningVote: not winning: vote=" + aChild + " is ongoing=" + ongoing + ", winning=" + winning);
        }
        if (result.size() == 1) {
            return (VotingView)result.get(0);
        }
        return null;
    }

    public static List<VotingView> getYesVotingsOf(ResourceResolver resourceResolver, Config config, String slingId) {
        if (resourceResolver == null) {
            throw new IllegalArgumentException("resourceResolver must not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (slingId == null || slingId.length() == 0) {
            throw new IllegalArgumentException("slingId must not be null or empty");
        }
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            return null;
        }
        Iterable children = ongoingVotingsResource.getChildren();
        if (children == null) {
            return null;
        }
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            if (!c.hasVotedYes(slingId)) continue;
            result.add(c);
        }
        if (result.size() >= 1) {
            return result;
        }
        return null;
    }

    public static List<VotingView> listVotings(ResourceResolver resourceResolver, Config config) {
        if (config == null) {
            logger.info("listVotings: config is null, bundle likely deactivated.");
            return new ArrayList<VotingView>();
        }
        String ongoingVotingsPath = config.getOngoingVotingsPath();
        Resource ongoingVotingsResource = resourceResolver.getResource(ongoingVotingsPath);
        if (ongoingVotingsResource == null) {
            logger.debug("listVotings: no ongoing votings parent resource found");
            return new ArrayList<VotingView>();
        }
        Iterable children = ongoingVotingsResource.getChildren();
        Iterator it = children.iterator();
        LinkedList<VotingView> result = new LinkedList<VotingView>();
        while (it.hasNext()) {
            Resource aChild = (Resource)it.next();
            VotingView c = new VotingView(aChild);
            result.add(c);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listVotings: votings found: " + result.size());
        }
        return result;
    }
}

