/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.cm.json.io.Configurations;

public abstract class AttributeableEntity {
    private final Map<String, JsonValue> attributes = new LinkedHashMap<String, JsonValue>();

    protected void setDefaults() {
    }

    public void clear() {
        this.setDefaults();
        this.attributes.clear();
    }

    public JsonObject toJSONObject() throws IOException {
        JsonObjectBuilder objectBuilder = this.createJson();
        return objectBuilder.build();
    }

    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        this.clear();
        try {
            for (Map.Entry entry : jsonObj.entrySet()) {
                this.getAttributes().put((String)entry.getKey(), (JsonValue)entry.getValue());
            }
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public Map<String, JsonValue> getAttributes() {
        return this.attributes;
    }

    protected JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, JsonValue> entry : this.getAttributes().entrySet()) {
            objectBuilder.add(entry.getKey(), entry.getValue());
        }
        return objectBuilder;
    }

    protected String getString(JsonValue jsonValue) {
        Object obj = Configurations.convertToObject((JsonValue)jsonValue);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    protected String getString(String attributeName) {
        Object obj;
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null && (obj = Configurations.convertToObject((JsonValue)val)) != null) {
            return obj.toString();
        }
        return null;
    }

    protected String[] getStringArray(String attributeName) throws IOException {
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null) {
            if (val.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray array = val.asJsonArray();
                String[] result = new String[array.size()];
                int i = 0;
                for (JsonValue v : array) {
                    result[i] = Configurations.convertToObject((JsonValue)v).toString();
                    ++i;
                }
                return result;
            }
            if (val.getValueType() == JsonValue.ValueType.STRING) {
                return new String[]{((JsonString)val).getString()};
            }
            throw new IOException("Invalid type for string array value " + attributeName + " : " + val.getValueType().name());
        }
        return null;
    }

    protected Number getNumber(String attributeName) throws IOException {
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null) {
            Object obj = Configurations.convertToObject((JsonValue)val);
            if (obj instanceof Number) {
                return (Number)obj;
            }
            throw new IOException("Invalid type for number value " + attributeName + " : " + val.getValueType().name());
        }
        return null;
    }

    protected void setString(JsonObjectBuilder builder, String attributeName, String value) {
        if (value != null) {
            builder.add(attributeName, value);
        }
    }

    protected void setStringArray(JsonObjectBuilder builder, String attributeName, String[] value) {
        if (value != null && value.length > 0) {
            JsonArrayBuilder jab = Json.createArrayBuilder();
            for (String v : value) {
                jab.add(v);
            }
            builder.add(attributeName, jab);
        }
    }

    protected int getInteger(String attributeName, int defaultValue) {
        String val = this.getString(attributeName);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return defaultValue;
    }

    protected boolean getBoolean(String attributeName, boolean defaultValue) throws IOException {
        JsonValue val = this.getAttributes().remove(attributeName);
        if (val != null) {
            Object obj = Configurations.convertToObject((JsonValue)val);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            throw new IOException("Invalid type for boolean value " + attributeName + " : " + val.getValueType().name());
        }
        return defaultValue;
    }
}

