/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.jcr.base.internal.mount.ProxyJackrabbitWorkspace;
import org.apache.sling.jcr.base.internal.mount.ProxyRepository;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyUserManager;

public class ProxyJackrabbitSession
extends ProxySession<JackrabbitSession>
implements JackrabbitSession {
    public ProxyJackrabbitSession(ProxyRepository repository, JackrabbitSession jcr, Session mount, Set<String> mountPoints) {
        super(repository, jcr, mount, mountPoints);
    }

    @Override
    public Workspace getWorkspace() {
        return new ProxyJackrabbitWorkspace((ProxySession)this, (JackrabbitWorkspace)((JackrabbitSession)this.jcr).getWorkspace(), (JackrabbitWorkspace)this.mount.getWorkspace());
    }

    public boolean hasPermission(String absPath, String ... actions) throws RepositoryException {
        if (this.isMount(absPath)) {
            return ((JackrabbitSession)this.mount).hasPermission(absPath, actions);
        }
        return ((JackrabbitSession)this.jcr).hasPermission(absPath, actions);
    }

    public PrincipalManager getPrincipalManager() throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        return ((JackrabbitSession)this.jcr).getPrincipalManager();
    }

    public UserManager getUserManager() throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        return new ProxyUserManager(this, ((JackrabbitSession)this.jcr).getUserManager(), ((JackrabbitSession)this.mount).getUserManager());
    }

    public Item getItemOrNull(String absPath) throws RepositoryException {
        if (super.itemExists(absPath)) {
            return super.getItem(absPath);
        }
        return null;
    }

    public Property getPropertyOrNull(String absPath) throws RepositoryException {
        if (super.propertyExists(absPath)) {
            return super.getProperty(absPath);
        }
        return null;
    }

    public Node getNodeOrNull(String absPath) throws RepositoryException {
        if (super.nodeExists(absPath)) {
            return super.getNode(absPath);
        }
        return null;
    }
}

