/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamPipe
extends BasePipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamPipe.class);
    public static final String REMOTE_START = "http";
    protected static final Pattern VALID_PATH = Pattern.compile("/([\\w\\.\\-_]+/)+[\\w\\.\\-_]+");
    public static final String BINDING_IS = "org.apache.sling.pipes.RequestInputStream";
    private static final String BASIC_AUTH_BINDINGS = "basicAuth";
    private static final String HEADER_PREFIX = "header_";
    private static final String AUTH_HEADER = "Authentication";
    private static final String BASIC_PREFIX = "Basic ";
    private static final String PN_URL_MODE = "url_mode";
    private static final String URL_MODE_FETCH = "FETCH";
    private static final String URL_MODE_AS_IS = "AS_IS";
    private static final String METHOD_POST = "POST";
    private static final String HEADER_TYPE = "Content-Type";
    private static final String HEADER_LENGTH = "Content-Length";
    private static final String QUERY_CHAR = "?";
    protected Object binding = null;
    InputStream is;

    public AbstractInputStreamPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    InputStream getInputStreamFromResource(String expr) {
        Resource resource = this.resolver.getResource(expr);
        if (resource != null) {
            return (InputStream)resource.adaptTo(InputStream.class);
        }
        return null;
    }

    void addHeaders(URLConnection connection) {
        connection.setRequestProperty("charset", "utf-8");
        Collection headers = this.properties.keySet().stream().filter(k -> k.startsWith(HEADER_PREFIX)).map(s -> StringUtils.substringAfter((String)s, (String)HEADER_PREFIX)).collect(Collectors.toList());
        if (!headers.isEmpty()) {
            for (String k2 : headers) {
                String value = this.getBindings().instantiateExpression((String)this.properties.get(HEADER_PREFIX + k2, String.class));
                connection.setRequestProperty(k2, value);
            }
            String basicAuth = (String)this.getBindings().getBindings().get(BASIC_AUTH_BINDINGS);
            if (StringUtils.isNotBlank((CharSequence)basicAuth)) {
                if (headers.contains(AUTH_HEADER)) {
                    LOGGER.warn("both authentication header & basic auth are set, ignoring basic auth");
                } else {
                    String encoded = Base64.getEncoder().encodeToString(basicAuth.getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty(AUTH_HEADER, BASIC_PREFIX + encoded);
                }
            }
        }
    }

    private URLConnection preparePost(String expr) throws IOException {
        String url = expr;
        String data = "";
        if (expr.contains(QUERY_CHAR)) {
            data = StringUtils.substringAfter((String)expr, (String)QUERY_CHAR);
            url = StringUtils.substringBefore((String)expr, (String)QUERY_CHAR);
        } else {
            data = this.getBindings().instantiateExpression((String)this.properties.get(METHOD_POST, String.class));
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(METHOD_POST);
        byte[] postData = data.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        if (expr.contains(QUERY_CHAR)) {
            connection.setRequestProperty(HEADER_TYPE, "application/x-www-form-urlencoded");
        }
        connection.setRequestProperty(HEADER_LENGTH, Integer.toString(postDataLength));
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        this.addHeaders(connection);
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.write(postData);
        }
        return connection;
    }

    URLConnection getConnection(String expr) throws IOException {
        URLConnection urlConnection;
        boolean usePost = this.properties.containsKey((Object)METHOD_POST);
        LOGGER.debug("Accessing {} (POST={})", (Object)expr, (Object)usePost);
        if (usePost) {
            if (this.isDryRun()) {
                LOGGER.debug("we won't execute a POST request in a dry run");
                return null;
            }
            urlConnection = this.preparePost(expr);
        } else {
            URL url = new URL(expr);
            urlConnection = url.openConnection();
            this.addHeaders(urlConnection);
        }
        return urlConnection;
    }

    InputStream getInputStream() throws IOException {
        InputStream resourceIs;
        String expr = this.getExpr();
        if (expr.startsWith(REMOTE_START) && !((String)this.properties.get(PN_URL_MODE, (Object)URL_MODE_FETCH)).equalsIgnoreCase(URL_MODE_AS_IS) && StringUtils.isNotBlank((CharSequence)expr)) {
            return this.getConnection(expr).getInputStream();
        }
        if (VALID_PATH.matcher(expr).find() && (resourceIs = this.getInputStreamFromResource(expr)) != null) {
            return resourceIs;
        }
        if (this.getBindings().getBindings().get(BINDING_IS) != null) {
            return (InputStream)this.getBindings().getBindings().get(BINDING_IS);
        }
        return new ByteArrayInputStream(expr.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Object getOutputBinding() {
        return this.binding;
    }

    public abstract Iterator<Resource> getOutput(InputStream var1);

    @Override
    public Iterator<Resource> computeOutput() {
        try {
            this.is = this.getInputStream();
            return this.getOutput(this.is);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void after() {
        super.after();
        IOUtils.closeQuietly((InputStream)this.is);
    }
}

