/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.inventory.impl;

import java.util.Iterator;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.inventory.impl.JsonObjectCreator;

public class ResourceTraversor {
    private final JsonObjectBuilder startObject;
    private final Resource startResource;

    public ResourceTraversor(Resource resource) {
        this.startResource = resource;
        this.startObject = this.adapt(resource);
    }

    public void collectResources() throws JsonException {
        this.collectChildren(this.startResource, this.startObject);
    }

    private void collectChildren(Resource resource, JsonObjectBuilder jsonObj) throws JsonException {
        Iterator children = resource.listChildren();
        while (children.hasNext()) {
            Resource res = (Resource)children.next();
            JsonObjectBuilder json = this.collectResource(res, jsonObj);
            this.collectChildren(res, json);
        }
    }

    private JsonObjectBuilder collectResource(Resource resource, JsonObjectBuilder parent) throws JsonException {
        JsonObjectBuilder o = this.adapt(resource);
        parent.add(resource.getName(), o);
        return o;
    }

    private JsonObjectBuilder adapt(Resource resource) throws JsonException {
        return JsonObjectCreator.create(resource);
    }

    public JsonObject getJsonObject() {
        return this.startObject.build();
    }
}

