/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.header.JakartaMediaRangeList;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingJakartaAllMethodsServlet;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.servlets.post.JakartaHtmlResponse;
import org.apache.sling.servlets.post.JakartaJSONResponse;
import org.apache.sling.servlets.post.JakartaNodeNameGenerator;
import org.apache.sling.servlets.post.JakartaPostOperation;
import org.apache.sling.servlets.post.JakartaPostResponse;
import org.apache.sling.servlets.post.JakartaPostResponseCreator;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.SlingJakartaPostProcessor;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.exceptions.PreconditionViolatedPersistenceException;
import org.apache.sling.servlets.post.impl.ErrorHandlingPostResponseWrapper;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.DefaultNodeNameGenerator;
import org.apache.sling.servlets.post.impl.helper.JCRSupport;
import org.apache.sling.servlets.post.impl.operations.CheckinOperation;
import org.apache.sling.servlets.post.impl.operations.CheckoutOperation;
import org.apache.sling.servlets.post.impl.operations.CopyOperation;
import org.apache.sling.servlets.post.impl.operations.DeleteOperation;
import org.apache.sling.servlets.post.impl.operations.ImportOperation;
import org.apache.sling.servlets.post.impl.operations.ModifyOperation;
import org.apache.sling.servlets.post.impl.operations.MoveOperation;
import org.apache.sling.servlets.post.impl.operations.NopOperation;
import org.apache.sling.servlets.post.impl.operations.RestoreOperation;
import org.apache.sling.servlets.post.impl.operations.StreamedUploadOperation;
import org.apache.sling.servlets.post.impl.wrapper.JavaxToJakartaNodeNameGenerator;
import org.apache.sling.servlets.post.impl.wrapper.JavaxToJakartaPostOperation;
import org.apache.sling.servlets.post.impl.wrapper.JavaxToJakartaPostResponseCreator;
import org.apache.sling.servlets.post.impl.wrapper.JavaxToSlingJakartaPostProcessor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Sling Post Servlet", "service.vendor=The Apache Software Foundation", "sling.servlet.prefix:Integer=-1", "sling.servlet.paths=sling/servlet/default/POST"})
@Designate(ocd=Config.class)
public class SlingPostServlet
extends SlingJakartaAllMethodsServlet {
    private static final long serialVersionUID = 1837674988291697074L;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_CHECKIN_ON_CREATE = ":checkinNewVersionableNodes";
    private static final String PARAM_AUTO_CHECKOUT = ":autoCheckout";
    private static final String PARAM_AUTO_CHECKIN = ":autoCheckin";
    private final ModifyOperation modifyOperation = new ModifyOperation();
    private final StreamedUploadOperation streamedUploadOperation = new StreamedUploadOperation();
    private ServiceRegistration<JakartaPostOperation>[] internalOperations;
    private final Map<String, JakartaPostOperation> postOperations = new HashMap<String, JakartaPostOperation>();
    private final List<PostProcessorHolder> postProcessors = new ArrayList<PostProcessorHolder>();
    private SlingJakartaPostProcessor[] cachedPostProcessors = new SlingJakartaPostProcessor[0];
    private final List<NodeNameGeneratorHolder> nodeNameGenerators = new ArrayList<NodeNameGeneratorHolder>();
    private JakartaNodeNameGenerator[] cachedNodeNameGenerators = new JakartaNodeNameGenerator[0];
    private final List<PostResponseCreatorHolder> postResponseCreators = new ArrayList<PostResponseCreatorHolder>();
    private JakartaPostResponseCreator[] cachedPostResponseCreators = new JakartaPostResponseCreator[0];
    private VersioningConfiguration baseVersioningConfiguration;
    private ImportOperation importOperation;
    private boolean backwardsCompatibleStatuscode;
    private boolean logStacktraceInExceptions;
    private static final Pattern REDIRECT_WITH_SCHEME_PATTERN = Pattern.compile("^(https?://[^/]+)(.*)$");

    public SlingPostServlet() {
        if (JCRSupport.INSTANCE.jcrEnabled()) {
            try {
                this.importOperation = new ImportOperation();
            }
            catch (Throwable t) {
                this.log.warn("Support for JCR operations like checkin, checkout, import, ordering etc. is currently disabled in the servlets post module. Check whether the JCR API is available.", t);
            }
        }
    }

    protected void doPost(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        VersioningConfiguration localVersioningConfig = this.createRequestVersioningConfiguration(request);
        request.setAttribute(VersioningConfiguration.class.getName(), (Object)localVersioningConfig);
        JakartaPostResponse htmlResponse = this.createPostResponse(request);
        htmlResponse.setReferer(request.getHeader("referer"));
        JakartaPostOperation operation = this.getSlingPostOperation(request);
        if (operation == null) {
            htmlResponse.setStatus(500, "Invalid operation specified for POST request");
        } else {
            request.getRequestProgressTracker().log("Calling PostOperation: {0}", new Object[]{operation.getClass().getName()});
            SlingJakartaPostProcessor[] processors = this.cachedPostProcessors;
            try {
                operation.run(request, htmlResponse, processors);
            }
            catch (ResourceNotFoundException rnfe) {
                htmlResponse.setStatus(404, rnfe.getMessage());
            }
            catch (PreconditionViolatedPersistenceException e) {
                this.logPersistenceException(request, operation, (Exception)((Object)e));
                if (this.backwardsCompatibleStatuscode) {
                    htmlResponse.setError((Throwable)((Object)e));
                } else {
                    htmlResponse.setStatus(422, "invalid payload");
                }
            }
            catch (PersistenceException e) {
                this.logPersistenceException(request, operation, (Exception)((Object)e));
                if (this.backwardsCompatibleStatuscode) {
                    htmlResponse.setError(e);
                } else {
                    htmlResponse.setStatus(409, "repository state conflicting with request");
                }
            }
            catch (Exception e) {
                this.log.warn("Exception while handling POST on path [{}] with operation [{}]", new Object[]{request.getResource().getPath(), operation.getClass().getName(), e});
                htmlResponse.setError(e);
            }
        }
        if (htmlResponse.isSuccessful() && this.redirectIfNeeded(request, htmlResponse, response)) {
            return;
        }
        htmlResponse.send((HttpServletResponse)response, this.isSetStatus(request));
    }

    protected void logPersistenceException(SlingJakartaHttpServletRequest request, JakartaPostOperation operation, Exception e) {
        if (this.logStacktraceInExceptions) {
            this.log.warn("Exception while handling POST on path [{}] with operation [{}]", new Object[]{request.getResource().getPath(), operation.getClass().getName(), e});
        } else {
            this.log.warn("{} while handling POST on path [{}] with operation [{}]: {}", new Object[]{e.getClass().getName(), request.getResource().getPath(), operation.getClass().getName(), e.getMessage()});
        }
    }

    boolean redirectIfNeeded(SlingJakartaHttpServletRequest request, JakartaPostResponse htmlResponse, SlingJakartaHttpServletResponse response) throws IOException {
        String redirectURL = this.getRedirectUrl(request, htmlResponse);
        if (redirectURL != null) {
            Object encodedURL;
            Matcher m = REDIRECT_WITH_SCHEME_PATTERN.matcher(redirectURL);
            boolean hasScheme = m.matches();
            if (hasScheme && m.group(2).length() > 0) {
                encodedURL = m.group(1) + response.encodeRedirectURL(m.group(2));
            } else if (hasScheme) {
                encodedURL = redirectURL;
            } else {
                this.log.debug("Request path is [{}]", (Object)request.getPathInfo());
                encodedURL = response.encodeRedirectURL(redirectURL);
            }
            this.log.debug("redirecting to URL [{}] - encoded as [{}]", (Object)redirectURL, encodedURL);
            response.sendRedirect((String)encodedURL);
            return true;
        }
        return false;
    }

    JakartaPostResponse createPostResponse(SlingJakartaHttpServletRequest req) {
        JakartaPostResponseCreator creator;
        JakartaPostResponse response = null;
        JakartaPostResponseCreator[] jakartaPostResponseCreatorArray = this.cachedPostResponseCreators;
        int n = jakartaPostResponseCreatorArray.length;
        for (int i = 0; i < n && (response = (creator = jakartaPostResponseCreatorArray[i]).createPostResponse(req)) == null; ++i) {
        }
        if (response == null) {
            JakartaMediaRangeList mediaRangeList = new JakartaMediaRangeList((HttpServletRequest)req);
            response = "application/json".equals(mediaRangeList.prefer(new String[]{"text/html", "application/json"})) ? new JakartaJSONResponse() : new JakartaHtmlResponse();
        }
        if (this.isSendError(req)) {
            response = new ErrorHandlingPostResponseWrapper(response);
        }
        return response;
    }

    private boolean isSendError(SlingJakartaHttpServletRequest request) {
        boolean sendError = false;
        String sendErrorParam = request.getParameter(":sendError");
        if (sendErrorParam != null && "true".equalsIgnoreCase(sendErrorParam)) {
            sendError = true;
        }
        return sendError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JakartaPostOperation getSlingPostOperation(SlingJakartaHttpServletRequest request) {
        if (this.streamedUploadOperation.isRequestStreamed(request)) {
            return this.streamedUploadOperation;
        }
        String operation = request.getParameter(":operation");
        if (operation == null || operation.length() == 0) {
            return this.modifyOperation;
        }
        Map<String, JakartaPostOperation> map = this.postOperations;
        synchronized (map) {
            return this.postOperations.get(operation);
        }
    }

    protected String getRedirectUrl(SlingJakartaHttpServletRequest request, JakartaPostResponse ctx) {
        String result = request.getParameter(":redirect");
        if (result != null) {
            try {
                URI redirectUri = new URI(result);
                if (redirectUri.getAuthority() != null) {
                    this.log.warn("redirect target ({}) does include host information ({}). This is not allowed for security reasons!", (Object)result, (Object)redirectUri.getAuthority());
                    return null;
                }
            }
            catch (URISyntaxException e) {
                this.log.warn("given redirect target ({}) is not a valid uri: {}", (Object)result, (Object)e);
                return null;
            }
            this.log.debug("redirect requested as [{}] for path [{}]", (Object)result, (Object)ctx.getPath());
            int star = result.indexOf(42);
            if (star >= 0 && ctx.getPath() != null) {
                String requestPath;
                StringBuilder buf = new StringBuilder();
                if (star > 0) {
                    buf.append(result.substring(0, star));
                }
                buf.append(ResourceUtil.getName((String)ctx.getPath()));
                if (star < result.length() - 1) {
                    buf.append(result.substring(star + 1));
                }
                if ((requestPath = request.getPathInfo()).endsWith("/") && buf.charAt(0) != '/' && !REDIRECT_WITH_SCHEME_PATTERN.matcher(buf).matches()) {
                    buf.insert(0, requestPath);
                }
                result = buf.toString();
            } else if (result.endsWith("/")) {
                result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
            }
            this.log.debug("Will redirect to {}", (Object)result);
        }
        return result;
    }

    protected boolean isSetStatus(SlingJakartaHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value {}, assuming standard status code", (Object)":status", (Object)statusParam);
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Config configuration) {
        this.configure(configuration);
        ArrayList<ServiceRegistration<JakartaPostOperation>> providedServices = new ArrayList<ServiceRegistration<JakartaPostOperation>>();
        providedServices.add(this.registerOperation(bundleContext, "modify", this.modifyOperation));
        providedServices.add(this.registerOperation(bundleContext, "copy", new CopyOperation()));
        providedServices.add(this.registerOperation(bundleContext, "move", new MoveOperation()));
        providedServices.add(this.registerOperation(bundleContext, "delete", new DeleteOperation()));
        providedServices.add(this.registerOperation(bundleContext, "nop", new NopOperation()));
        if (JCRSupport.INSTANCE.jcrEnabled() && this.importOperation != null) {
            providedServices.add(this.registerOperation(bundleContext, "import", this.importOperation));
            providedServices.add(this.registerOperation(bundleContext, "checkin", new CheckinOperation()));
            providedServices.add(this.registerOperation(bundleContext, "checkout", new CheckoutOperation()));
            providedServices.add(this.registerOperation(bundleContext, "restore", new RestoreOperation()));
        }
        this.internalOperations = providedServices.toArray(new ServiceRegistration[providedServices.size()]);
    }

    private ServiceRegistration<JakartaPostOperation> registerOperation(BundleContext context, String opCode, JakartaPostOperation operation) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("sling.post.operation", opCode);
        properties.put("service.description", "Apache Sling POST Servlet Operation " + opCode);
        properties.put("service.vendor", context.getBundle().getHeaders().get("Bundle-Vendor"));
        return context.registerService(JakartaPostOperation.class, (Object)operation, properties);
    }

    public void init() throws ServletException {
        this.modifyOperation.setServletContext(this.getServletContext());
        this.streamedUploadOperation.setServletContext(this.getServletContext());
    }

    @Modified
    private void configure(Config configuration) {
        String[] dateFormats;
        this.baseVersioningConfiguration = this.createBaseVersioningConfiguration(configuration);
        DateParser dateParser = new DateParser();
        for (String dateFormat : dateFormats = configuration.servlet_post_dateFormats()) {
            try {
                dateParser.register(dateFormat);
            }
            catch (Throwable t) {
                this.log.warn("configure: Ignoring DateParser format {} because it is invalid: {}", (Object)dateFormat, (Object)t);
            }
        }
        String[] nameHints = configuration.servlet_post_nodeNameHints();
        int nameMax = configuration.servlet_post_nodeNameMaxLength();
        DefaultNodeNameGenerator nodeNameGenerator = new DefaultNodeNameGenerator(nameHints, nameMax);
        String paramMatch = configuration.servlet_post_ignorePattern();
        Pattern paramMatchPattern = Pattern.compile(paramMatch);
        this.modifyOperation.setDateParser(dateParser);
        this.modifyOperation.setDefaultNodeNameGenerator(nodeNameGenerator);
        this.modifyOperation.setIgnoredParameterNamePattern(paramMatchPattern);
        if (this.importOperation != null) {
            this.importOperation.setDefaultNodeNameGenerator(nodeNameGenerator);
            this.importOperation.setIgnoredParameterNamePattern(paramMatchPattern);
        }
        this.backwardsCompatibleStatuscode = configuration.legacy_statuscode_on_persistence_exception();
        this.logStacktraceInExceptions = configuration.logStacktraceInExceptions();
    }

    public void destroy() {
        this.modifyOperation.setServletContext(null);
        this.streamedUploadOperation.setServletContext(null);
    }

    @Deactivate
    protected void deactivate() {
        if (this.internalOperations != null) {
            for (ServiceRegistration<JakartaPostOperation> registration : this.internalOperations) {
                registration.unregister();
            }
            this.internalOperations = null;
        }
        this.modifyOperation.setExtraNodeNameGenerators(null);
        if (this.importOperation != null) {
            this.importOperation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JakartaPostOperation.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJakartaPostOperation(JakartaPostOperation operation, Map<String, Object> properties) {
        String operationName = (String)properties.get("sling.post.operation");
        if (operationName != null && operation != null) {
            Map<String, JakartaPostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.put(operationName, operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJakartaPostOperation(JakartaPostOperation operation, Map<String, Object> properties) {
        String operationName = (String)properties.get("sling.post.operation");
        if (operationName != null) {
            Map<String, JakartaPostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.remove(operationName);
            }
        }
    }

    @Reference(service=PostOperation.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostOperation(PostOperation operation, Map<String, Object> properties) {
        this.bindJakartaPostOperation(new JavaxToJakartaPostOperation(operation), properties);
    }

    protected void unbindPostOperation(PostOperation operation, Map<String, Object> properties) {
        this.unbindJakartaPostOperation(new JavaxToJakartaPostOperation(operation), properties);
    }

    private int getRanking(Map<String, Object> properties) {
        Object val = properties.get("service.ranking");
        return val instanceof Integer ? (Integer)val : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=SlingJakartaPostProcessor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJakartaPostProcessor(SlingJakartaPostProcessor processor, Map<String, Object> properties) {
        PostProcessorHolder pph = new PostProcessorHolder();
        pph.processor = processor;
        pph.ranking = this.getRanking(properties);
        List<PostProcessorHolder> list = this.postProcessors;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postProcessors.size() && pph.ranking < this.postProcessors.get((int)index).ranking; ++index) {
            }
            if (index == this.postProcessors.size()) {
                this.postProcessors.add(pph);
            } else {
                this.postProcessors.add(index, pph);
            }
            this.updatePostProcessorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJakartaPostProcessor(SlingJakartaPostProcessor processor, Map<String, Object> properties) {
        List<PostProcessorHolder> list = this.postProcessors;
        synchronized (list) {
            Iterator<PostProcessorHolder> i = this.postProcessors.iterator();
            while (i.hasNext()) {
                PostProcessorHolder current = i.next();
                if (!current.isSame(processor)) continue;
                i.remove();
            }
            this.updatePostProcessorCache();
        }
    }

    @Reference(service=SlingPostProcessor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostProcessor(SlingPostProcessor processor, Map<String, Object> properties) {
        this.bindJakartaPostProcessor(new JavaxToSlingJakartaPostProcessor(processor), properties);
    }

    protected void unbindPostProcessor(SlingPostProcessor processor, Map<String, Object> properties) {
        this.unbindJakartaPostProcessor(new JavaxToSlingJakartaPostProcessor(processor), properties);
    }

    private void updatePostProcessorCache() {
        SlingJakartaPostProcessor[] localCache = new SlingJakartaPostProcessor[this.postProcessors.size()];
        int index = 0;
        for (PostProcessorHolder current : this.postProcessors) {
            localCache[index] = current.processor;
            ++index;
        }
        this.cachedPostProcessors = localCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JakartaNodeNameGenerator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJakartaNodeNameGenerator(JakartaNodeNameGenerator generator, Map<String, Object> properties) {
        NodeNameGeneratorHolder nngh = new NodeNameGeneratorHolder();
        nngh.generator = generator;
        nngh.ranking = this.getRanking(properties);
        List<NodeNameGeneratorHolder> list = this.nodeNameGenerators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.nodeNameGenerators.size() && nngh.ranking < this.nodeNameGenerators.get((int)index).ranking; ++index) {
            }
            if (index == this.nodeNameGenerators.size()) {
                this.nodeNameGenerators.add(nngh);
            } else {
                this.nodeNameGenerators.add(index, nngh);
            }
            this.updateNodeNameGeneratorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJakartaNodeNameGenerator(JakartaNodeNameGenerator generator, Map<String, Object> properties) {
        List<NodeNameGeneratorHolder> list = this.nodeNameGenerators;
        synchronized (list) {
            Iterator<NodeNameGeneratorHolder> i = this.nodeNameGenerators.iterator();
            while (i.hasNext()) {
                NodeNameGeneratorHolder current = i.next();
                if (!current.isSame(generator)) continue;
                i.remove();
            }
            this.updateNodeNameGeneratorCache();
        }
    }

    @Reference(service=NodeNameGenerator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindNodeNameGenerator(NodeNameGenerator generator, Map<String, Object> properties) {
        this.bindJakartaNodeNameGenerator(new JavaxToJakartaNodeNameGenerator(generator), properties);
    }

    protected void unbindNodeNameGenerator(NodeNameGenerator generator, Map<String, Object> properties) {
        this.unbindJakartaNodeNameGenerator(new JavaxToJakartaNodeNameGenerator(generator), properties);
    }

    private void updateNodeNameGeneratorCache() {
        JakartaNodeNameGenerator[] localCache = new JakartaNodeNameGenerator[this.nodeNameGenerators.size()];
        int index = 0;
        for (NodeNameGeneratorHolder current : this.nodeNameGenerators) {
            localCache[index] = current.generator;
            ++index;
        }
        this.cachedNodeNameGenerators = localCache;
        this.modifyOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        if (this.importOperation != null) {
            this.importOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JakartaPostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindJakartaPostResponseCreator(JakartaPostResponseCreator creator, Map<String, Object> properties) {
        PostResponseCreatorHolder nngh = new PostResponseCreatorHolder();
        nngh.creator = creator;
        nngh.ranking = this.getRanking(properties);
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postResponseCreators.size() && nngh.ranking < this.postResponseCreators.get((int)index).ranking; ++index) {
            }
            if (index == this.postResponseCreators.size()) {
                this.postResponseCreators.add(nngh);
            } else {
                this.postResponseCreators.add(index, nngh);
            }
            this.updatePostResponseCreatorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindJakartaPostResponseCreator(JakartaPostResponseCreator creator, Map<String, Object> properties) {
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            Iterator<PostResponseCreatorHolder> i = this.postResponseCreators.iterator();
            while (i.hasNext()) {
                PostResponseCreatorHolder current = i.next();
                if (!current.isSame(creator)) continue;
                i.remove();
            }
            this.updatePostResponseCreatorCache();
        }
    }

    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        this.bindJakartaPostResponseCreator(new JavaxToJakartaPostResponseCreator(creator), properties);
    }

    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        this.unbindJakartaPostResponseCreator(new JavaxToJakartaPostResponseCreator(creator), properties);
    }

    private void updatePostResponseCreatorCache() {
        JakartaPostResponseCreator[] localCache = new JakartaPostResponseCreator[this.postResponseCreators.size()];
        int index = 0;
        for (PostResponseCreatorHolder current : this.postResponseCreators) {
            localCache[index] = current.creator;
            ++index;
        }
        this.cachedPostResponseCreators = localCache;
    }

    @Reference(service=ContentImporter.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindContentImporter(Object importer) {
        if (this.importOperation != null) {
            this.importOperation.setContentImporter(importer);
        }
    }

    protected void unbindContentImporter(Object importer) {
        if (this.importOperation != null) {
            this.importOperation.unsetContentImporter(importer);
        }
    }

    private VersioningConfiguration createBaseVersioningConfiguration(Config config) {
        VersioningConfiguration cfg = new VersioningConfiguration();
        cfg.setCheckinOnNewVersionableNode(config.servlet_post_checkinNewVersionableNodes());
        cfg.setAutoCheckout(config.servlet_post_autoCheckout());
        cfg.setAutoCheckin(config.servlet_post_autoCheckin());
        return cfg;
    }

    private VersioningConfiguration createRequestVersioningConfiguration(SlingJakartaHttpServletRequest request) {
        VersioningConfiguration cfg = this.baseVersioningConfiguration.clone();
        String paramValue = request.getParameter(PARAM_CHECKIN_ON_CREATE);
        if (paramValue != null) {
            cfg.setCheckinOnNewVersionableNode(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKOUT)) != null) {
            cfg.setAutoCheckout(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKIN)) != null) {
            cfg.setAutoCheckin(Boolean.parseBoolean(paramValue));
        }
        return cfg;
    }

    protected void setLog(Logger log) {
        this.log = log;
    }

    protected void setLogStacktraceInExceptions(boolean flag) {
        this.logStacktraceInExceptions = flag;
    }

    @ObjectClassDefinition(name="Apache Sling POST Servlet", description="The Sling POST Servlet is registered as the default servlet to handle POST requests in Sling.")
    public static @interface Config {
        @AttributeDefinition(name="Date Format", description="List SimpleDateFormat strings for date formats supported for parsing from request input to data fields. The special format \"ISO8601\" (without the quotes) can be used to designate strict ISO-8601 parser which is able to parse strings generated by the Property.getString() method for Date properties. The default value is [ \"EEE MMM dd yyyy HH:mm:ss 'GMT'Z\", \"ISO8601\", \"yyyy-MM-dd'T'HH:mm:ss.SSSZ\", \"yyyy-MM-dd'T'HH:mm:ss\", \"yyyy-MM-dd\", \"dd.MM.yyyy HH:mm:ss\", \"dd.MM.yyyy\" ].")
        public String[] servlet_post_dateFormats() default {"EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "ISO8601", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy"};

        @AttributeDefinition(name="Node Name Hint Properties", description="The list of properties whose values may be used to derive a name for newly created nodes. When handling a request to create a new node, the name of the node is automatically generated if the request URL ends with a star (\"*\") or a slash (\"/\"). In this case the request parameters listed in this configuration value may be used to create the name. Default value is [ \"title\", \"jcr:title\", \"name\", \"description\", \"jcr:description\", \"abstract\", \"text\", \"jcr:text\" ].")
        public String[] servlet_post_nodeNameHints() default {"title", "jcr:title", "name", "description", "jcr:description", "abstract", "text", "jcr:text"};

        @AttributeDefinition(name="Maximum Node Name Length", description="Maximum number of characters to use for automatically generated node names. The default value is 20. Note, that actual node names may be generated with at most 4 more characters if the numeric suffixes must be appended to make the name unique.")
        public int servlet_post_nodeNameMaxLength() default 20;

        @AttributeDefinition(name="Checkin New Versionable Nodes", description="If true, newly created versionable nodes or non-versionable nodes which are made versionable by the addition of the mix:versionable mixin are checked in. By default, false.")
        public boolean servlet_post_checkinNewVersionableNodes() default false;

        @AttributeDefinition(name="Auto Checkout Nodes", description="If true, checked in nodes are checked out when necessary. By default, false.")
        public boolean servlet_post_autoCheckout() default false;

        @AttributeDefinition(name="Auto Checkin Nodes", description="If true, nodes which are checked out by the post servlet are checked in. By default, true.")
        public boolean servlet_post_autoCheckin() default true;

        @AttributeDefinition(name="Ignored Parameters", description="Configures a regular expression pattern to select request parameters which should be ignored when writing content to the repository. By default this is \"j_.*\" thus ignoring all request parameters starting with j_ such as j_username.")
        public String servlet_post_ignorePattern() default "j_.*";

        @AttributeDefinition(name="Backwards compatible statuscode", description="In backwards compatibility mode exceptions will always create a statuscode 500 (see SLING-9896)")
        public boolean legacy_statuscode_on_persistence_exception() default false;

        @AttributeDefinition(name="Log stacktraces on exceptions", description="Log the full stacktrace in case of an exception")
        public boolean logStacktraceInExceptions() default true;
    }

    private static final class PostProcessorHolder {
        public SlingJakartaPostProcessor processor;
        public int ranking;

        private PostProcessorHolder() {
        }

        public boolean isSame(SlingJakartaPostProcessor processor) {
            if (this.processor == processor) {
                return true;
            }
            if (processor instanceof JavaxToSlingJakartaPostProcessor && this.processor instanceof JavaxToSlingJakartaPostProcessor) {
                return ((JavaxToSlingJakartaPostProcessor)processor).getDelegate() == ((JavaxToSlingJakartaPostProcessor)this.processor).getDelegate();
            }
            return false;
        }
    }

    private static final class NodeNameGeneratorHolder {
        public JakartaNodeNameGenerator generator;
        public int ranking;

        private NodeNameGeneratorHolder() {
        }

        public boolean isSame(JakartaNodeNameGenerator generator) {
            if (this.generator == generator) {
                return true;
            }
            if (generator instanceof JavaxToJakartaNodeNameGenerator && this.generator instanceof JavaxToJakartaNodeNameGenerator) {
                return ((JavaxToJakartaNodeNameGenerator)generator).getDelegate() == ((JavaxToJakartaNodeNameGenerator)this.generator).getDelegate();
            }
            return false;
        }
    }

    private static final class PostResponseCreatorHolder {
        public JakartaPostResponseCreator creator;
        public int ranking;

        private PostResponseCreatorHolder() {
        }

        public boolean isSame(JakartaPostResponseCreator creator) {
            if (this.creator == creator) {
                return true;
            }
            if (creator instanceof JavaxToJakartaPostResponseCreator && this.creator instanceof JavaxToJakartaPostResponseCreator) {
                return ((JavaxToJakartaPostResponseCreator)creator).getDelegate() == ((JavaxToJakartaPostResponseCreator)this.creator).getDelegate();
            }
            return false;
        }
    }
}

