/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.superimposing.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.superimposing.impl.SuperimposingResource;
import org.apache.sling.superimposing.impl.SuperimposingResourceProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperimposingResourceIterator
implements Iterator<Resource> {
    private final SuperimposingResourceProviderImpl superimposingProvider;
    private final Iterator<Resource> decoratee;
    private Resource next;

    SuperimposingResourceIterator(SuperimposingResourceProviderImpl superimposingProvider, Iterator<Resource> decoratee) {
        this.superimposingProvider = superimposingProvider;
        this.decoratee = decoratee;
        this.seek();
    }

    private void seek() {
        this.next = null;
        while (this.next == null && this.decoratee.hasNext()) {
            Resource resource = this.decoratee.next();
            String superimposingPath = SuperimposingResourceProviderImpl.reverseMapPath(this.superimposingProvider, resource.getPath());
            if (null == superimposingPath) continue;
            this.next = new SuperimposingResource(resource, superimposingPath);
        }
    }

    @Override
    public boolean hasNext() {
        return null != this.next;
    }

    @Override
    public Resource next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Resource current = this.next;
        this.seek();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

