/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.version;

import java.util.Calendar;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.plugins.migration.DescendantsIterator;
import org.apache.jackrabbit.oak.plugins.migration.NodeStateCopier;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionCopyConfiguration;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionHistoryUtil;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class VersionCopier {
    private final NodeState sourceVersionStorage;
    private final NodeBuilder targetVersionStorage;
    private final Supplier<Boolean> frozenNodeIsReferenceable;

    public VersionCopier(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage) {
        this.sourceVersionStorage = sourceVersionStorage;
        this.targetVersionStorage = targetVersionStorage;
        this.frozenNodeIsReferenceable = new IsFrozenNodeReferenceable(targetRoot.getNodeState());
    }

    public static void copyVersionStorage(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage, VersionCopyConfiguration config) {
        DescendantsIterator versionStorageIterator = new DescendantsIterator(sourceVersionStorage, 3);
        VersionCopier versionCopier = new VersionCopier(targetRoot, sourceVersionStorage, targetVersionStorage);
        while (versionStorageIterator.hasNext()) {
            NodeState versionHistoryBucket = (NodeState)versionStorageIterator.next();
            for (String versionHistory : versionHistoryBucket.getChildNodeNames()) {
                versionCopier.copyVersionHistory(versionHistory, config.getOrphanedMinDate());
            }
        }
    }

    public boolean copyVersionHistory(String versionableUuid, Calendar minDate) {
        String versionHistoryPath = VersionHistoryUtil.getRelativeVersionHistoryPath(versionableUuid);
        NodeState sourceVersionHistory = VersionHistoryUtil.getVersionHistoryNodeState(this.sourceVersionStorage, versionableUuid);
        Calendar lastModified = VersionHistoryUtil.getVersionHistoryLastModified(sourceVersionHistory);
        if (sourceVersionHistory.exists() && (lastModified.after(minDate) || minDate.getTimeInMillis() == 0L)) {
            NodeStateCopier.builder().include(versionHistoryPath).merge("/jcr:system/jcr:versionStorage").withReferenceableFrozenNodes(this.frozenNodeIsReferenceable.get()).copy(this.sourceVersionStorage, this.targetVersionStorage);
            return true;
        }
        return false;
    }

    private static final class IsFrozenNodeReferenceable
    implements Supplier<Boolean> {
        private final NodeState root;
        private Boolean isReferenceable;

        public IsFrozenNodeReferenceable(NodeState root) {
            this.root = root;
        }

        @Override
        public Boolean get() {
            if (this.isReferenceable == null) {
                this.isReferenceable = Utils.isFrozenNodeReferenceable(this.root);
            }
            return this.isReferenceable;
        }
    }
}

