/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;
import sling-mock-oak.com.google.common.collect.Lists;

public class CompositeEditorProvider
implements EditorProvider {
    private static final EditorProvider EMPTY_PROVIDER = new EditorProvider(){

        @Override
        @Nullable
        public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
            return null;
        }
    };
    private final Collection<? extends EditorProvider> providers;

    @NotNull
    public static EditorProvider compose(@NotNull Collection<? extends EditorProvider> providers) {
        Preconditions.checkNotNull(providers);
        switch (providers.size()) {
            case 0: {
                return EMPTY_PROVIDER;
            }
            case 1: {
                return providers.iterator().next();
            }
        }
        return new CompositeEditorProvider(providers);
    }

    private CompositeEditorProvider(Collection<? extends EditorProvider> providers) {
        this.providers = providers;
    }

    public CompositeEditorProvider(EditorProvider ... providers) {
        this(Arrays.asList(providers));
    }

    @Override
    @Nullable
    public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
        ArrayList<Editor> list = Lists.newArrayListWithCapacity(this.providers.size());
        for (EditorProvider editorProvider : this.providers) {
            Editor editor = editorProvider.getRootEditor(before, after, builder, info);
            if (editor == null) continue;
            list.add(editor);
        }
        return CompositeEditor.compose(list);
    }

    public String toString() {
        return "CompositeEditorProvider : (" + this.providers.toString() + ")";
    }
}

