/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.cache;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCacheStats
extends AnnotatedStandardMBean
implements CacheStatsMBean {
    @NotNull
    private final String name;
    private CacheStats lastSnapshot = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);

    protected AbstractCacheStats(@NotNull String name) {
        super(CacheStatsMBean.class);
        this.name = Objects.requireNonNull(name);
    }

    protected abstract CacheStats getCurrentStats();

    private CacheStats stats() {
        return this.getCurrentStats().minus(this.lastSnapshot);
    }

    @Override
    public synchronized void resetStats() {
        this.lastSnapshot = this.getCurrentStats();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public long getRequestCount() {
        return this.stats().requestCount();
    }

    @Override
    public long getHitCount() {
        return this.stats().hitCount();
    }

    @Override
    public double getHitRate() {
        return this.stats().hitRate();
    }

    @Override
    public long getMissCount() {
        return this.stats().missCount();
    }

    @Override
    public double getMissRate() {
        return this.stats().missRate();
    }

    @Override
    public long getLoadCount() {
        return this.stats().loadCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.stats().loadSuccessCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.stats().loadExceptionCount();
    }

    @Override
    public double getLoadExceptionRate() {
        return this.stats().loadExceptionRate();
    }

    @Override
    public long getTotalLoadTime() {
        return this.stats().totalLoadTime();
    }

    @Override
    public double getAverageLoadPenalty() {
        return this.stats().averageLoadPenalty();
    }

    @Override
    public long getEvictionCount() {
        return this.stats().evictionCount();
    }

    @Override
    public String cacheInfoAsString() {
        return new StringJoiner(", ", "CacheStats [", "]").add("hitCount=" + this.getHitCount()).add("hitRate=" + String.format("%1.2f", this.getHitRate())).add("missCount=" + this.getMissCount()).add("missRate=" + String.format("%1.2f", this.getMissRate())).add("requestCount=" + this.getRequestCount()).add("loadCount=" + this.getLoadCount()).add("loadSuccessCount=" + this.getLoadSuccessCount()).add("loadExceptionCount=" + this.getLoadExceptionCount()).add("totalLoadTime=" + AbstractCacheStats.timeInWords(this.getTotalLoadTime())).add("averageLoadPenalty=" + String.format("%1.2f ns", this.getAverageLoadPenalty())).add("evictionCount=" + this.getEvictionCount()).add("elementCount=" + this.getElementCount()).add("totalWeight=" + IOUtils.humanReadableByteCount(this.estimateCurrentWeight())).add("maxWeight=" + IOUtils.humanReadableByteCount(this.getMaxTotalWeight())).toString();
    }

    public static String timeInWords(long nanos) {
        long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }
}

