/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011O\u0011\u0015Y\u0006\u0001\"\u0011O\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t9\u0002\u0001C)\u00033A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u0005-\u0002!%A\u0005\u0002\u00055\u0002\"CA\"\u0001E\u0005I\u0011AA\u0017\u0011%\t)\u0005AA\u0001\n\u0003\n9\u0005C\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003S\u0002\u0011\u0011!C!\u0003WB\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAF\u0001\u0005\u0005I\u0011IAG\u000f%\t\t\fIA\u0001\u0012\u0003\t\u0019L\u0002\u0005 A\u0005\u0005\t\u0012AA[\u0011\u0019)\u0016\u0004\"\u0001\u0002N\"I\u0011qZ\r\u0002\u0002\u0013\u0015\u0013\u0011\u001b\u0005\n\u0003'L\u0012\u0011!CA\u0003+D\u0011\"a7\u001a\u0003\u0003%\t)!8\t\u0013\u0005=\u0018$!A\u0005\n\u0005E(\u0001D*ue&twMU3qK\u0006$(BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001q#'\u000e\u001fC!\ty\u0003'D\u0001!\u0013\t\t\u0004E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011qfM\u0005\u0003i\u0001\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003mer!aL\u001c\n\u0005a\u0002\u0013a\u00029bG.\fw-Z\u0005\u0003um\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u00029AA\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t9\u0001K]8ek\u000e$\bCA\"K\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002HY\u00051AH]8pizJ\u0011aP\u0005\u0003qyJ!a\u0013'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005ar\u0014aA:ueV\tq\n\u0005\u00020!&\u0011\u0011\u000b\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001B:ue\u0002\nQ\u0001^5nKN\fa\u0001^5nKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002X1f\u0003\"a\f\u0001\t\u000b5+\u0001\u0019A(\t\u000bM+\u0001\u0019A(\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\tI\u0006$\u0018\rV=qKV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002bI\u0005)A/\u001f9fg&\u00111\r\u0019\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0019\u00042aQ4_\u0013\tAGJA\u0002TKF\fAB\\;mYN\u000bg-Z#wC2$2a\u001b8q!\tiD.\u0003\u0002n}\t\u0019\u0011I\\=\t\u000b=T\u0001\u0019A6\u0002\rM$(/\u001b8h\u0011\u0015\t(\u00021\u0001l\u0003\u0005q\u0017A\u00039sKR$\u0018PT1nKV\tA\u000f\u0005\u0002vs:\u0011ao\u001e\t\u0003\u000bzJ!\u0001\u001f \u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003qz\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u000by\fI!a\u0005\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0011\u0002\u000f\r|G-Z4f]&!\u0011qAA\u0001\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0006\u0019\u0001\u0007\u0011QB\u0001\u0004GRD\bcA@\u0002\u0010%!\u0011\u0011CA\u0001\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0006\r\u0001\u0004q\u0018AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003X\u00037\ty\u0002\u0003\u0004\u0002\u001e5\u0001\raT\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\t#\u0004a\u0001\u001f\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B,\u0002(\u0005%\u0002bB'\u000f!\u0003\u0005\ra\u0014\u0005\b':\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\f+\u0007=\u000b\td\u000b\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!C;oG\",7m[3e\u0015\r\tiDP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA!\u0003o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-C\u0002{\u0003\u001b\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0017\u0011\u0007u\ni&C\u0002\u0002`y\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a[A3\u0011%\t9gEA\u0001\u0002\u0004\tY&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003[\u0002R!a\u001c\u0002v-l!!!\u001d\u000b\u0007\u0005Md(\u0001\u0006d_2dWm\u0019;j_:LA!a\u001e\u0002r\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti(a!\u0011\u0007u\ny(C\u0002\u0002\u0002z\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002hU\t\t\u00111\u0001l\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%\u0013\u0011\u0012\u0005\n\u0003O2\u0012\u0011!a\u0001\u00037\na!Z9vC2\u001cH\u0003BA?\u0003\u001fC\u0001\"a\u001a\u0018\u0003\u0003\u0005\ra\u001b\u0015\u0014\u0001\u0005M\u0015\u0011TAN\u0003?\u000b\t+!*\u0002(\u0006-\u0016Q\u0016\t\u0004_\u0005U\u0015bAALA\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAO\u0003E{f)\u0016(D?\"\u001aHO\u001d\u0017!]&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002\u0012X\r]3biN\u0004C\u000f[3!O&4XM\u001c\u0011tiJLgn\u001a\u0011wC2,X\r\t8!i&lWm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a)\u0002\u0001*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a4O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cI\u001a\u0014GM\u001a\u000bA\u0001\nQa]5oG\u0016\f#!!+\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0016\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001D*ue&twMU3qK\u0006$\bCA\u0018\u001a'\u0015I\u0012qWAb!\u001d\tI,a0P\u001f^k!!a/\u000b\u0007\u0005uf(A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00171\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAc\u0003\u0017l!!a2\u000b\t\u0005%\u0017\u0011K\u0001\u0003S>L1aSAd)\t\t\u0019,\u0001\u0005u_N#(/\u001b8h)\t\tI%A\u0003baBd\u0017\u0010F\u0003X\u0003/\fI\u000eC\u0003N9\u0001\u0007q\nC\u0003T9\u0001\u0007q*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00171\u001e\t\u0006{\u0005\u0005\u0018Q]\u0005\u0004\u0003Gt$AB(qi&|g\u000eE\u0003>\u0003O|u*C\u0002\u0002jz\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAw;\u0005\u0005\t\u0019A,\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002tB!\u00111JA{\u0013\u0011\t90!\u0014\u0003\r=\u0013'.Z2u\u0001")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat x$0) {
        return StringRepeat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(l, r) -> new StringBuilder(11).append("(").append((String)l).append(").repeat(").append((String)r).append(")").toString());
    }

    @Override
    public StringRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.str();
                break;
            }
            case 1: {
                object = this.times();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "str";
                break;
            }
            case 1: {
                string = "times";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

