/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([timeExp[, fmt]]) - Returns the UNIX timestamp of current or specified time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string. If not provided, this defaults to current time.\n      * fmt - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n              Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\"> Datetime Patterns</a>\n              for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001B\u0015+\u0001^B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u00039\u0006\u0002C2\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u0011\u0011\u0004!Q3A\u0005\u0002\u0015D\u0001\"\u001b\u0001\u0003\u0012\u0003\u0006IA\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006U\u0002!\t!\u001d\u0005\u0006i\u0002!\te\u0014\u0005\u0006k\u0002!\te\u0014\u0005\u0006m\u0002!\te\u001e\u0005\u0006U\u0002!\t\u0001 \u0005\u0006U\u0002!\ta \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t)\u0001\u0001C)\u0003\u000fA\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u0010\u0011%\t9\u0004AI\u0001\n\u0003\tI\u0004C\u0005\u0002>\u0001\t\n\u0011\"\u0001\u0002@!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013Q\t\u0005\n\u0003+\u0002\u0011\u0011!C\u0001\u0003/B\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t\u0019\tAA\u0001\n\u0003\n)\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\u001eI\u0011Q\u0017\u0016\u0002\u0002#\u0005\u0011q\u0017\u0004\tS)\n\t\u0011#\u0001\u0002:\"1!n\bC\u0001\u0003#D\u0011\"a5 \u0003\u0003%)%!6\t\u0013\u0005]w$!A\u0005\u0002\u0006e\u0007\"CAr?E\u0005I\u0011AA\u001d\u0011%\t)oHI\u0001\n\u0003\ty\u0004C\u0005\u0002h~\t\t\u0011\"!\u0002j\"I\u0011q_\u0010\u0012\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003s|\u0012\u0013!C\u0001\u0003\u007fA\u0011\"a? \u0003\u0003%I!!@\u0003\u001bUs\u0017\u000e\u001f+j[\u0016\u001cH/Y7q\u0015\tYC&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0017/\u0003!\u0019\u0017\r^1msN$(BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO\u000e\u00011\u0003\u0002\u00019y\t\u0003\"!\u000f\u001e\u000e\u0003)J!a\u000f\u0016\u0003\u0011Us\u0017\u000e\u001f+j[\u0016\u0004\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0017:\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fZ\na\u0001\u0010:p_Rt\u0014\"A \n\u0005)s\u0014a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0013 \u0002\u000fQLW.Z#yaV\t\u0001\u000b\u0005\u0002:#&\u0011!K\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u0003;j[\u0016,\u0005\u0010\u001d\u0011\u0002\r\u0019|'/\\1u\u0003\u001d1wN]7bi\u0002\n!\u0002^5nKj{g.Z%e+\u0005A\u0006cA\u001fZ7&\u0011!L\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005q\u0003gBA/_!\t)e(\u0003\u0002`}\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyf(A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012A\u001a\t\u0003{\u001dL!\u0001\u001b \u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"R\u0001\\7o_B\u0004\"!\u000f\u0001\t\u000b9K\u0001\u0019\u0001)\t\u000bQK\u0001\u0019\u0001)\t\u000fYK\u0001\u0013!a\u00011\"9A-\u0003I\u0001\u0002\u00041Gc\u00017sg\")aJ\u0003a\u0001!\")AK\u0003a\u0001!\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\tA8\u0010\u0005\u0002:s&\u0011!P\u000b\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:DQAV\u0007A\u0002m#\"\u0001\\?\t\u000byt\u0001\u0019\u0001)\u0002\tQLW.\u001a\u000b\u0002Y\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003m\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b1\fI!!\u0004\t\r\u0005-\u0011\u00031\u0001Q\u0003\u001dqWm\u001e'fMRDa!a\u0004\u0012\u0001\u0004\u0001\u0016\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\nY\u0006U\u0011qCA\r\u00037AqA\u0014\n\u0011\u0002\u0003\u0007\u0001\u000bC\u0004U%A\u0005\t\u0019\u0001)\t\u000fY\u0013\u0002\u0013!a\u00011\"9AM\u0005I\u0001\u0002\u00041\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CQ3\u0001UA\u0012W\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0018}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYDK\u0002Y\u0003G\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002B)\u001aa-a\t\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003#\nAA[1wC&\u0019\u0011-a\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0003cA\u001f\u0002\\%\u0019\u0011Q\f \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0014\u0011\u000e\t\u0004{\u0005\u0015\u0014bAA4}\t\u0019\u0011I\\=\t\u0013\u0005-\u0014$!AA\u0002\u0005e\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002rA1\u00111OA=\u0003Gj!!!\u001e\u000b\u0007\u0005]d(\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0002v\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r1\u0017\u0011\u0011\u0005\n\u0003WZ\u0012\u0011!a\u0001\u0003G\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qIAD\u0011%\tY\u0007HA\u0001\u0002\u0004\tI&\u0001\u0004fcV\fGn\u001d\u000b\u0004M\u00065\u0005\"CA6;\u0005\u0005\t\u0019AA2Q]\u0001\u0011\u0011SAL\u00033\u000bi*a(\u0002$\u0006\u0015\u0016\u0011VAV\u0003_\u000b\t\fE\u0002:\u0003'K1!!&+\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a'\u0002'~3UKT\"`Qm#\u0018.\\3FqB\\F\u0006\t4nivk\u0016\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI+O\u0013b\u0003C/[7fgR\fW\u000e\u001d\u0011pM\u0002\u001aWO\u001d:f]R\u0004sN\u001d\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"\u0018.\\3/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\"\u0006\u0019YD\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lW-\u0012=qA5\u0002\u0013\t\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002\u001aHO]5oO:\u0002\u0013J\u001a\u0011o_R\u0004\u0003O]8wS\u0012,G\r\f\u0011uQ&\u001c\b\u0005Z3gCVdGo\u001d\u0011u_\u0002\u001aWO\u001d:f]R\u0004C/[7f])\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\u0015\r^30i&lW\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u0002\u0013j\u001a8pe\u0016$\u0007%\u001b4!ARLW.Z#ya\u0002\u0004\u0013n\u001d\u0011o_R\u0004\u0013\rI:ue&twM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011EK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u0011jg\u0002\u0012\u00130_=z[5kU\u0006\u001a3!\u0011\"ST.\u001c\u001etg\nr\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017eCR,G/[7f[A\fG\u000f^3s]:BG/\u001c7#}\u0001\"\u0015\r^3uS6,\u0007\u0005U1ui\u0016\u0014hn\u001d\u001f0CzR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002cm\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,\u0007%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9+AA\u0002\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00195oYB\u0004\b\u000e\u001c4o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\u0002D'\f\u00199O1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001b7aA\"\u0014G\r\u00191\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAW\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a-\u0002\u000bErSG\f\u0019\u0002\u001bUs\u0017\u000e\u001f+j[\u0016\u001cH/Y7q!\tItdE\u0003 \u0003w\u000b9\rE\u0005\u0002>\u0006\r\u0007\u000b\u0015-gY6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003t\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u000b\fyLA\tBEN$(/Y2u\rVt7\r^5p]R\u0002B!!3\u0002P6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy%\u0001\u0002j_&\u0019A*a3\u0015\u0005\u0005]\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0013!B1qa2LH#\u00037\u0002\\\u0006u\u0017q\\Aq\u0011\u0015q%\u00051\u0001Q\u0011\u0015!&\u00051\u0001Q\u0011\u001d1&\u0005%AA\u0002aCq\u0001\u001a\u0012\u0011\u0002\u0003\u0007a-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\f\u0019\u0010\u0005\u0003>3\u00065\bcB\u001f\u0002pB\u0003\u0006LZ\u0005\u0004\u0003ct$A\u0002+va2,G\u0007\u0003\u0005\u0002v\u0016\n\t\u00111\u0001m\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ty\u0010\u0005\u0003\u0002J\t\u0005\u0011\u0002\u0002B\u0002\u0003\u0017\u0012aa\u00142kK\u000e$\b")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(UnixTimestamp x$0) {
        return UnixTimestamp$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return UnixTimestamp$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return UnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, UnixTimestamp>>>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    @Override
    public UnixTimestamp withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public UnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        return new UnixTimestamp(timeExp, format, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeExp();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "timeExp";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            case 3: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        if (this.failOnError() != unixTimestamp.failOnError()) return false;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = unixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
    }

    public UnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

