/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mf!B\u0010!\u0001\u0011b\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011m\u0002!\u0011!Q\u0001\nqB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0013\u0002!\tAS\u0003\u0005\u001f\u0002!\u0001\u000b\u0003\u0005`\u0001!\u0015\r\u0011\"\u0003a\u0011!1\u0007\u0001#b\u0001\n\u00139\u0007\u0002\u00035\u0001\u0011\u000b\u0007I\u0011B4\t\u000f%\u0004!\u0019!C\u0005U\"1q\u000f\u0001Q\u0001\n-Dq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002>\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0005\t\u0013\u0005}\u0001A1A\u0005\n\u0005=\u0001\u0002CA\u0011\u0001\u0001\u0006I!!\u0005\t\u0013\u0005\r\u0002A1A\u0005\n\u0005\u0015\u0002\u0002CA\u0017\u0001\u0001\u0006I!a\n\t\u000f\u0005=\u0002\u0001\"\u0003\u00022!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!a#\u0001\t\u0013\ti\tC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005%\u0006\u0001\"\u0001\u0002(\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAV\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003W\u0003A\u0011AA[\u0011\u001d\tI\f\u0001C\u0001\u0003O\u0013\u0001CS1dWN|gnR3oKJ\fGo\u001c:\u000b\u0005\u0005\u0012\u0013\u0001\u00026t_:T!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h'\t\u0001Q\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VMZ\u0001\tI\u0006$\u0018\rV=qK\u000e\u0001\u0001C\u0001\u001c:\u001b\u00059$B\u0001\u001d%\u0003\u0015!\u0018\u0010]3t\u0013\tQtG\u0001\u0005ECR\fG+\u001f9f\u0003\u00199(/\u001b;feB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0003S>T\u0011!Q\u0001\u0005U\u00064\u0018-\u0003\u0002D}\t1qK]5uKJ\fqa\u001c9uS>t7\u000f\u0005\u0002G\u000f6\t\u0001%\u0003\u0002IA\tY!jU(O\u001fB$\u0018n\u001c8t\u0003\u0019a\u0014N\\5u}Q!1\nT'O!\t1\u0005\u0001C\u00034\t\u0001\u0007Q\u0007C\u0003<\t\u0001\u0007A\bC\u0003E\t\u0001\u0007QIA\u0006WC2,Xm\u0016:ji\u0016\u0014\b#\u0002\u0018R'fc\u0016B\u0001*0\u0005%1UO\\2uS>t'\u0007\u0005\u0002U/6\tQK\u0003\u0002WE\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tAVK\u0001\nTa\u0016\u001c\u0017.\u00197ju\u0016$w)\u001a;uKJ\u001c\bC\u0001\u0018[\u0013\tYvFA\u0002J]R\u0004\"AL/\n\u0005y{#\u0001B+oSR\f\u0001C]8pi\u001aKW\r\u001c3Xe&$XM]:\u0016\u0003\u0005\u00042A\f2e\u0013\t\u0019wFA\u0003BeJ\f\u0017\u0010\u0005\u0002f\u000b5\t\u0001!\u0001\tbeJ,E.Z7f]R<&/\u001b;feV\tA-\u0001\tnCB,E.Z7f]R<&/\u001b;fe\u0006\u0019q-\u001a8\u0016\u0003-\u0004\"\u0001\\;\u000e\u00035T!A\\8\u0002\t\r|'/\u001a\u0006\u0003aF\fqA[1dWN|gN\u0003\u0002sg\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0002i\u0006\u00191m\\7\n\u0005Yl'!\u0004&t_:<UM\\3sCR|'/\u0001\u0003hK:\u0004\u0013!\u00047j]\u0016\u001cV\r]1sCR|'/F\u0001{!\rY\u0018Q\u0001\b\u0004y\u0006\u0005\u0001CA?0\u001b\u0005q(BA@5\u0003\u0019a$o\\8u}%\u0019\u00111A\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t9!!\u0003\u0003\rM#(/\u001b8h\u0015\r\t\u0019aL\u0001\u000fY&tWmU3qCJ\fGo\u001c:!\u0003I!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]!%\u0001\u0003vi&d\u0017\u0002BA\u000e\u0003+\u0011!\u0003V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\u0006\u0019B/[7fgR\fW\u000e\u001d$pe6\fG\u000f^3sA\u0005)B/[7fgR\fW\u000e\u001d(U5\u001a{'/\\1ui\u0016\u0014\u0018A\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM\u001d\u0011\u0002\u001b\u0011\fG/\u001a$pe6\fG\u000f^3s+\t\t9\u0003\u0005\u0003\u0002\u0014\u0005%\u0012\u0002BA\u0016\u0003+\u0011Q\u0002R1uK\u001a{'/\\1ui\u0016\u0014\u0018A\u00043bi\u00164uN]7biR,'\u000fI\u0001\u000b[\u0006\\Wm\u0016:ji\u0016\u0014Hc\u00013\u00024!)1g\u0005a\u0001k\u0005YqO]5uK>\u0013'.Z2u)\ra\u0016\u0011\b\u0005\t\u0003w!B\u00111\u0001\u0002>\u0005\ta\r\u0005\u0003/\u0003\u007fa\u0016bAA!_\tAAHY=oC6,g(A\u0006xe&$XMR5fY\u0012\u001cHc\u0002/\u0002H\u0005M\u0013Q\f\u0005\b\u0003\u0013*\u0002\u0019AA&\u0003\r\u0011xn\u001e\t\u0005\u0003\u001b\ny%D\u0001#\u0013\r\t\tF\t\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002VU\u0001\r!a\u0016\u0002\rM\u001c\u0007.Z7b!\r1\u0014\u0011L\u0005\u0004\u00037:$AC*ueV\u001cG\u000fV=qK\"9\u0011qL\u000bA\u0002\u0005\u0005\u0014\u0001\u00044jK2$wK]5uKJ\u001c\b#BA2\u0003[\"g\u0002BA3\u0003Sr1!`A4\u0013\u0005\u0001\u0014bAA6_\u00059\u0001/Y2lC\u001e,\u0017\u0002BA8\u0003c\u00121aU3r\u0015\r\tYgL\u0001\u000boJLG/Z!se\u0006LHc\u0001/\u0002x!A\u00111\b\f\u0005\u0002\u0004\ti$\u0001\bxe&$X-\u0011:sCf$\u0015\r^1\u0015\u000bq\u000bi(a\"\t\u000f\u0005}t\u00031\u0001\u0002\u0002\u0006)\u0011M\u001d:bsB!\u00111CAB\u0013\u0011\t))!\u0006\u0003\u0013\u0005\u0013(/Y=ECR\f\u0007BBAE/\u0001\u0007A-A\u0006gS\u0016dGm\u0016:ji\u0016\u0014\u0018\u0001D<sSR,W*\u00199ECR\fGc\u0002/\u0002\u0010\u0006e\u00151\u0015\u0005\b\u0003#C\u0002\u0019AAJ\u0003\ri\u0017\r\u001d\t\u0005\u0003'\t)*\u0003\u0003\u0002\u0018\u0006U!aB'ba\u0012\u000bG/\u0019\u0005\b\u00037C\u0002\u0019AAO\u0003\u001di\u0017\r\u001d+za\u0016\u00042ANAP\u0013\r\t\tk\u000e\u0002\b\u001b\u0006\u0004H+\u001f9f\u0011\u0019\tI\t\u0007a\u0001I\u0006)1\r\\8tKR\tA,A\u0003gYV\u001c\b.A\u0003xe&$X\rF\u0002]\u0003_Cq!!\u0013\u001c\u0001\u0004\tY\u0005F\u0002]\u0003gCq!a \u001d\u0001\u0004\t\t\tF\u0002]\u0003oCq!!%\u001e\u0001\u0004\t\u0019*A\bxe&$X\rT5oK\u0016sG-\u001b8h\u0001")
public class JacksonGenerator {
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter;
    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter;
    private final DataType dataType;
    private final JSONOptions options;
    private final JsonGenerator gen;
    private final String lineSeparator;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private volatile byte bitmap$0;

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType2 = this.dataType;
                if (!(dataType2 instanceof StructType)) {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypeError(this.dataType, StructType$.MODULE$.simpleString());
                }
                StructType structType = (StructType)dataType2;
                Function2[] function2Array = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                this.rootFieldWriters = function2Array;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootFieldWriters;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rootFieldWriters$lzycompute() : this.rootFieldWriters;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Function2<SpecializedGetters, Object, BoxedUnit> function2;
                DataType dataType = this.dataType;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    function2 = this.makeWriter(arrayType.elementType());
                } else {
                    boolean bl = dataType instanceof StructType ? true : dataType instanceof MapType;
                    if (bl) {
                        function2 = this.makeWriter(this.dataType);
                    } else {
                        throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypesError(this.dataType);
                    }
                }
                this.arrElementWriter = function2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.arrElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.arrElementWriter$lzycompute() : this.arrElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                DataType dataType = this.dataType;
                if (!(dataType instanceof MapType)) {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypeError(this.dataType, MapType$.MODULE$.simpleString());
                }
                MapType mapType = (MapType)dataType;
                Function2<SpecializedGetters, Object, BoxedUnit> function2 = this.makeWriter(mapType.valueType());
                this.mapElementWriter = function2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mapElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.mapElementWriter$lzycompute() : this.mapElementWriter;
    }

    private JsonGenerator gen() {
        return this.gen;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        Function2 & Serializable intersect;
        block21: {
            while (true) {
                DataType dataType3;
                if (NullType$.MODULE$.equals(dataType3 = dataType2)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (BooleanType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ByteType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (ShortType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (IntegerType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (LongType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (FloatType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (DoubleType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (StringType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (TimestampType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (DateType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType3;
                    byte start = yearMonthIntervalType.startField();
                    byte end = yearMonthIntervalType.endField();
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$14(this, start, end, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType3;
                    byte start = dayTimeIntervalType.startField();
                    byte end = dayTimeIntervalType.endField();
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$15(this, start, end, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (BinaryType$.MODULE$.equals(dataType3)) {
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$16(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType3;
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        JacksonGenerator.$anonfun$makeWriter$17(this, decimalType, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof StructType) {
                    StructType structType = (StructType)dataType3;
                    Seq fieldWriters = (Seq)((IterableOps)structType.map((Function1 & Serializable)x$2 -> x$2.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType));
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, (Seq<Function2<SpecializedGetters, Object, BoxedUnit>>)fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        this.writeArray((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeArrayData(row.getArray(BoxesRunTime.unboxToInt((Object)ordinal)), (Function2<SpecializedGetters, Object, BoxedUnit>)elementWriter));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (dataType3 instanceof MapType) {
                    MapType mapType = (MapType)dataType3;
                    Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
                    intersect = (Function2 & Serializable)(row, ordinal) -> {
                        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeMapData(row.getMap(BoxesRunTime.unboxToInt((Object)ordinal)), mapType, (Function2<SpecializedGetters, Object, BoxedUnit>)valueWriter));
                        return BoxedUnit.UNIT;
                    };
                    break block21;
                }
                if (!(dataType3 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = userDefinedType.sqlType();
            }
            intersect = (Function2 & Serializable)(row, ordinal) -> JacksonGenerator.$anonfun$makeWriter$26(dataType2, row, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        return intersect;
    }

    private void writeObject(Function0<BoxedUnit> f) {
        this.gen().writeStartObject();
        f.apply$mcV$sp();
        this.gen().writeEndObject();
    }

    private void writeFields(InternalRow row, StructType schema, Seq<Function2<SpecializedGetters, Object, BoxedUnit>> fieldWriters) {
        for (int i = 0; i < row.numFields(); ++i) {
            Object object;
            StructField field = schema.apply(i);
            if (!row.isNullAt(i)) {
                this.gen().writeFieldName(field.name());
                object = ((Function2)fieldWriters.apply(i)).apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.options.ignoreNullFields() || this.options.writeNullIfWithDefaultValue() && field.getExistenceDefaultValue().isDefined()) {
                this.gen().writeFieldName(field.name());
                this.gen().writeNull();
            }
            object = BoxedUnit.UNIT;
        }
    }

    private void writeArray(Function0<BoxedUnit> f) {
        this.gen().writeStartArray();
        f.apply$mcV$sp();
        this.gen().writeEndArray();
    }

    private void writeArrayData(ArrayData array, Function2<SpecializedGetters, Object, BoxedUnit> fieldWriter) {
        for (int i = 0; i < array.numElements(); ++i) {
            Object object;
            if (!array.isNullAt(i)) {
                object = fieldWriter.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            this.gen().writeNull();
            object = BoxedUnit.UNIT;
        }
    }

    private void writeMapData(MapData map, MapType mapType, Function2<SpecializedGetters, Object, BoxedUnit> fieldWriter) {
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        for (int i = 0; i < map.numElements(); ++i) {
            Object object;
            this.gen().writeFieldName(keyArray.get(i, mapType.keyType()).toString());
            if (!valueArray.isNullAt(i)) {
                object = fieldWriter.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            this.gen().writeNull();
            object = BoxedUnit.UNIT;
        }
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public void write(InternalRow row) {
        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            IndexedSeq x$1 = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(this.rootFieldWriters());
            InternalRow x$2 = row;
            StructType x$3 = (StructType)$this.dataType;
            this.writeFields(x$2, x$3, (Seq<Function2<SpecializedGetters, Object, BoxedUnit>>)x$1);
        });
    }

    public void write(ArrayData array) {
        this.writeArray((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeArrayData(array, this.arrElementWriter()));
    }

    public void write(MapData map) {
        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Function2<SpecializedGetters, Object, BoxedUnit> x$1 = this.mapElementWriter();
            MapData x$2 = map;
            MapType x$3 = (MapType)$this.dataType;
            this.writeMapData(x$2, x$3, x$1);
        });
    }

    public void writeLineEnding() {
        this.gen().writeRaw(this.lineSeparator());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNull();
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber((short)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeString(row.getUTF8String(ordinal).toString());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timestampString = $this.timestampFormatter().format(row.getLong(ordinal));
        $this.gen().writeString(timestampString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timestampString = $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(row.getLong(ordinal)));
        $this.gen().writeString(timestampString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String dateString = $this.dateFormatter().format(row.getInt(ordinal));
        $this.gen().writeString(dateString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeString(row.getInterval(ordinal).toString());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$14(JacksonGenerator $this, byte start$1, byte end$1, SpecializedGetters row, int ordinal) {
        String ymString = IntervalUtils$.MODULE$.toYearMonthIntervalString(row.getInt(ordinal), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start$1, end$1);
        $this.gen().writeString(ymString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$15(JacksonGenerator $this, byte start$2, byte end$2, SpecializedGetters row, int ordinal) {
        String dtString = IntervalUtils$.MODULE$.toDayTimeIntervalString(row.getLong(ordinal), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start$2, end$2);
        $this.gen().writeString(dtString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$16(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeBinary(row.getBinary(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$17(JacksonGenerator $this, DecimalType x18$1, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getDecimal(ordinal, x18$1.precision(), x18$1.scale()).toJavaBigDecimal());
    }

    public static final /* synthetic */ Nothing$ $anonfun$makeWriter$26(DataType dataType$1, SpecializedGetters row, int ordinal) {
        Object v = row.get(ordinal, dataType$1);
        throw QueryExecutionErrors$.MODULE$.failToConvertValueToJsonError(v, v.getClass(), dataType$1);
    }

    public JacksonGenerator(DataType dataType, Writer writer, JSONOptions options) {
        this.dataType = dataType;
        this.options = options;
        Predef$.MODULE$.require(dataType instanceof StructType || dataType instanceof MapType || dataType instanceof ArrayType, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(58).append("JacksonGenerator only supports to be initialized with a ").append(StructType$.MODULE$.simpleString()).append(", ").toString()).append(new StringBuilder(13).append(MapType$.MODULE$.simpleString()).append(" or ").append(ArrayType$.MODULE$.simpleString()).append(" but got ").append($this.dataType.catalogString()).toString()).toString());
        JsonGenerator generator = new JsonFactory().createGenerator(writer).setRootValueSeparator(null);
        Object object = options.pretty() ? generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter("")) : BoxedUnit.UNIT;
        Object object2 = options.writeNonAsciiCharacterAsCodePoint() ? generator.setHighestNonEscapedChar(127) : BoxedUnit.UNIT;
        this.gen = generator;
        this.lineSeparator = options.lineSeparatorInWrite();
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
    }
}

