/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.util.SparkParserUtils;
import org.apache.spark.sql.errors.QueryParsingErrors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class ParserUtils$
implements SparkParserUtils {
    public static final ParserUtils$ MODULE$ = new ParserUtils$();
    private static final Regex escapedIdentifier;
    private static final Regex qualifiedEscapedIdentifier;
    private static Regex U16_CHAR_PATTERN;
    private static Regex U32_CHAR_PATTERN;
    private static Regex OCTAL_CHAR_PATTERN;
    private static Regex ESCAPED_CHAR_PATTERN;

    static {
        SparkParserUtils.$init$((SparkParserUtils)MODULE$);
        escapedIdentifier = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("`((?s).+)`"));
        qualifiedEscapedIdentifier = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("((?s).+).`((?s).+)`"));
    }

    public String unescapeSQLString(String b) {
        return SparkParserUtils.unescapeSQLString$((SparkParserUtils)this, (String)b);
    }

    public String string(Token token) {
        return SparkParserUtils.string$((SparkParserUtils)this, (Token)token);
    }

    public String string(TerminalNode node) {
        return SparkParserUtils.string$((SparkParserUtils)this, (TerminalNode)node);
    }

    public Origin position(Token token) {
        return SparkParserUtils.position$((SparkParserUtils)this, (Token)token);
    }

    public <T> T withOrigin(ParserRuleContext ctx, Option<String> sqlText, Function0<T> f) {
        return (T)SparkParserUtils.withOrigin$((SparkParserUtils)this, (ParserRuleContext)ctx, sqlText, f);
    }

    public <T> Option<String> withOrigin$default$2() {
        return SparkParserUtils.withOrigin$default$2$((SparkParserUtils)this);
    }

    public Origin positionAndText(Token startToken, Token stopToken, String sqlText, Option<String> objectType, Option<String> objectName) {
        return SparkParserUtils.positionAndText$((SparkParserUtils)this, (Token)startToken, (Token)stopToken, (String)sqlText, objectType, objectName);
    }

    public String command(ParserRuleContext ctx) {
        return SparkParserUtils.command$((SparkParserUtils)this, (ParserRuleContext)ctx);
    }

    public Regex U16_CHAR_PATTERN() {
        return U16_CHAR_PATTERN;
    }

    public Regex U32_CHAR_PATTERN() {
        return U32_CHAR_PATTERN;
    }

    public Regex OCTAL_CHAR_PATTERN() {
        return OCTAL_CHAR_PATTERN;
    }

    public Regex ESCAPED_CHAR_PATTERN() {
        return ESCAPED_CHAR_PATTERN;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$U16_CHAR_PATTERN_$eq(Regex x$1) {
        U16_CHAR_PATTERN = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$U32_CHAR_PATTERN_$eq(Regex x$1) {
        U32_CHAR_PATTERN = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$OCTAL_CHAR_PATTERN_$eq(Regex x$1) {
        OCTAL_CHAR_PATTERN = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$SparkParserUtils$_setter_$ESCAPED_CHAR_PATTERN_$eq(Regex x$1) {
        ESCAPED_CHAR_PATTERN = x$1;
    }

    public Nothing$ operationNotAllowed(String message, ParserRuleContext ctx) {
        throw QueryParsingErrors$.MODULE$.operationNotAllowedError(message, ctx);
    }

    public <T> void checkDuplicateClauses(List<T> nodes, String clauseName, ParserRuleContext ctx) {
        if (nodes.size() > 1) {
            throw QueryParsingErrors$.MODULE$.duplicateClausesError(clauseName, ctx);
        }
    }

    public <T> void checkDuplicateKeys(Seq<Tuple2<String, T>> keyPairs, ParserRuleContext ctx) {
        ((IterableOnceOps)keyPairs.groupBy((Function1 & Serializable)x$1 -> (String)x$1._1()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParserUtils$.$anonfun$checkDuplicateKeys$2(x$2)))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                throw QueryParsingErrors$.MODULE$.duplicateKeysError(key, ctx);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String source(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
    }

    public String remainder(ParserRuleContext ctx) {
        return this.remainder(ctx.getStop());
    }

    public String remainder(Token token) {
        CharStream stream = token.getInputStream();
        Interval interval = Interval.of((int)(token.getStopIndex() + 1), (int)(stream.size() - 1));
        return stream.getText(interval);
    }

    public String interval(Token start, Token end) {
        Interval interval = Interval.of((int)(start.getStopIndex() + 1), (int)(end.getStartIndex() - 1));
        return start.getInputStream().getText(interval);
    }

    public String stringWithoutUnescape(Token node) {
        return StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(node.getText()), 1, StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(node.getText())) - 1);
    }

    public Seq<Tuple2<String, String>> entry(String key, Token value) {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)value)).toSeq().map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.string((Token)x)));
    }

    public void validate(Function0<Object> f, String message, ParserRuleContext ctx) {
        if (!f.apply$mcZ$sp()) {
            throw new ParseException("_LEGACY_ERROR_TEMP_0064", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)message)})), ctx);
        }
    }

    public Regex escapedIdentifier() {
        return escapedIdentifier;
    }

    public Regex qualifiedEscapedIdentifier() {
        return qualifiedEscapedIdentifier;
    }

    public String toExprAlias(ParseTree ctx) {
        StringBuilder sb = new StringBuilder();
        ParserUtils$.concatTerms$1(ctx, sb);
        return sb.toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkDuplicateKeys$2(Tuple2 x$2) {
        return ((SeqOps)x$2._2()).size() > 1;
    }

    public static final /* synthetic */ Object $anonfun$toExprAlias$1(ParseTree ctx$2, StringBuilder sb$1, int i) {
        BoxedUnit boxedUnit;
        ParseTree parseTree = ctx$2.getChild(i);
        if (parseTree instanceof TerminalNodeImpl) {
            TerminalNodeImpl terminalNodeImpl = (TerminalNodeImpl)parseTree;
            String termText = terminalNodeImpl.getText();
            int tt = terminalNodeImpl.getSymbol().getType();
            String current = 8 <= tt && tt <= 336 || 363 <= tt && tt <= 371 ? termText.toUpperCase(Locale.ROOT) : termText;
            boxedUnit = sb$1.append(current);
        } else {
            ParserUtils$.concatTerms$1(parseTree, sb$1);
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    private static final void concatTerms$1(ParseTree ctx, StringBuilder sb$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ctx.getChildCount()).foreach((Function1 & Serializable)i -> ParserUtils$.$anonfun$toExprAlias$1(ctx, sb$1, BoxesRunTime.unboxToInt((Object)i)));
    }

    private ParserUtils$() {
    }
}

