/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.metrics.source.DoubleAccumulatorSource$;
import org.apache.spark.metrics.source.LongAccumulatorSource$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.LongAccumulator;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class AccumulatorMetricsTest$ {
    public static final AccumulatorMetricsTest$ MODULE$ = new AccumulatorMetricsTest$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().config("spark.metrics.conf.*.sink.console.class", "org.apache.spark.metrics.sink.ConsoleSink").getOrCreate();
        SparkContext sc = spark.sparkContext();
        LongAccumulator acc = sc.longAccumulator("my-long-metric");
        LongAccumulatorSource$.MODULE$.register(sc, ((IterableOnceOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my-long-metric"), (Object)acc)}))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        DoubleAccumulator acc2 = sc.doubleAccumulator("my-double-metric");
        DoubleAccumulatorSource$.MODULE$.register(sc, ((IterableOnceOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"my-double-metric"), (Object)acc2)}))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        int num = args.length > 0 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0])) : 1000000;
        long startTime = System.nanoTime();
        sc.parallelize((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), num), sc.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            acc.add(1L);
            acc2.add(1.1);
        });
        BoxedUnit accumulatorTest = BoxedUnit.UNIT;
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Test took %.0f milliseconds"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - startTime) / 1000000.0))})));
        Predef$.MODULE$.println((Object)"Accumulator values:");
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("*** Long accumulator (my-long-metric): ").append(acc.value()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(43).append("*** Double accumulator (my-double-metric): ").append(acc2.value()).toString());
        spark.stop();
    }

    private AccumulatorMetricsTest$() {
    }
}

