/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class LinearRegressionWithElasticNetExample$ {
    public static final LinearRegressionWithElasticNetExample$ MODULE$ = new LinearRegressionWithElasticNetExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("LinearRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt");
        LinearRegression lr = new LinearRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LinearRegressionModel lrModel = (LinearRegressionModel)lr.fit(training);
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("Coefficients: ").append(lrModel.coefficients()).append(" Intercept: ").append(lrModel.intercept()).toString());
        LinearRegressionTrainingSummary trainingSummary = lrModel.summary();
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("numIterations: ").append(trainingSummary.totalIterations()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("objectiveHistory: [").append(Predef$.MODULE$.wrapDoubleArray(trainingSummary.objectiveHistory()).mkString(",")).append("]").toString());
        trainingSummary.residuals().show();
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("RMSE: ").append(trainingSummary.rootMeanSquaredError()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(4).append("r2: ").append(trainingSummary.r2()).toString());
        spark.stop();
    }

    private LinearRegressionWithElasticNetExample$() {
    }
}

