/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.BinaryClassification;
import org.apache.spark.examples.mllib.BinaryClassification$;
import org.apache.spark.examples.mllib.BinaryClassification$Algorithm$;
import org.apache.spark.examples.mllib.BinaryClassification$Params$;
import org.apache.spark.examples.mllib.BinaryClassification$RegType$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class BinaryClassification$ {
    public static final BinaryClassification$ MODULE$ = new BinaryClassification$();

    public void main(String[] args) {
        BinaryClassification.Params defaultParams = new BinaryClassification.Params(BinaryClassification$Params$.MODULE$.apply$default$1(), BinaryClassification$Params$.MODULE$.apply$default$2(), BinaryClassification$Params$.MODULE$.apply$default$3(), BinaryClassification$Params$.MODULE$.apply$default$4(), BinaryClassification$Params$.MODULE$.apply$default$5(), BinaryClassification$Params$.MODULE$.apply$default$6());
        OptionParser<BinaryClassification.Params> parser = new OptionParser<BinaryClassification.Params>(defaultParams){

            public static final /* synthetic */ BinaryClassification.Params $anonfun$new$1(int x, BinaryClassification.Params c) {
                int x$1 = x;
                String x$2 = c.copy$default$1();
                double x$3 = c.copy$default$3();
                Enumeration.Value x$4 = c.copy$default$4();
                Enumeration.Value x$5 = c.copy$default$5();
                double x$6 = c.copy$default$6();
                return c.copy(x$2, x$1, x$3, x$4, x$5, x$6);
            }

            public static final /* synthetic */ BinaryClassification.Params $anonfun$new$2(double x, BinaryClassification.Params c) {
                double x$7 = x;
                String x$8 = c.copy$default$1();
                int x$9 = c.copy$default$2();
                Enumeration.Value x$10 = c.copy$default$4();
                Enumeration.Value x$11 = c.copy$default$5();
                double x$12 = c.copy$default$6();
                return c.copy(x$8, x$9, x$7, x$10, x$11, x$12);
            }
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"BinaryClassification: an example app for binary classification."}));
                this.opt("numIterations", Read$.MODULE$.intRead()).text("number of iterations").action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("stepSize", Read$.MODULE$.doubleRead()).text(new StringBuilder(52).append("initial step size (ignored by logistic regression), ").append(new StringBuilder(9).append("default: ").append(defaultParams$1.stepSize()).toString()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("algorithm", Read$.MODULE$.stringRead()).text(new StringBuilder(0).append(new StringBuilder(14).append("algorithm (").append(BinaryClassification$Algorithm$.MODULE$.values().mkString(",")).append("), ").toString()).append(new StringBuilder(9).append("default: ").append(defaultParams$1.algorithm()).toString()).toString()).action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$13 = BinaryClassification$Algorithm$.MODULE$.withName((String)x);
                    String x$14 = c.copy$default$1();
                    int x$15 = c.copy$default$2();
                    double x$16 = c.copy$default$3();
                    Enumeration.Value x$17 = c.copy$default$5();
                    double x$18 = c.copy$default$6();
                    return c.copy(x$14, x$15, x$16, x$13, x$17, x$18);
                });
                this.opt("regType", Read$.MODULE$.stringRead()).text(new StringBuilder(0).append(new StringBuilder(24).append("regularization type (").append(BinaryClassification$RegType$.MODULE$.values().mkString(",")).append("), ").toString()).append(new StringBuilder(9).append("default: ").append(defaultParams$1.regType()).toString()).toString()).action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$19 = BinaryClassification$RegType$.MODULE$.withName((String)x);
                    String x$20 = c.copy$default$1();
                    int x$21 = c.copy$default$2();
                    double x$22 = c.copy$default$3();
                    Enumeration.Value x$23 = c.copy$default$4();
                    double x$24 = c.copy$default$6();
                    return c.copy(x$20, x$21, x$22, x$23, x$19, x$24);
                });
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringBuilder(35).append("regularization parameter, default: ").append(defaultParams$1.regParam()).toString());
                this.arg("<input>", Read$.MODULE$.stringRead()).required().text("input paths to labeled examples in LIBSVM format").action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6()));
                this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a synthetic dataset:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.mllib.BinaryClassification \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  --algorithm LR --regType L2 --regParam 1.0 \\\n          |  data/mllib/sample_binary_classification_data.txt\n        ")));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.mllib.BinaryClassification$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.mllib.BinaryClassification$Params ), $anonfun$new$3(java.lang.String org.apache.spark.examples.mllib.BinaryClassification$Params ), $anonfun$new$4(java.lang.String org.apache.spark.examples.mllib.BinaryClassification$Params ), $anonfun$new$5(java.lang.String org.apache.spark.examples.mllib.BinaryClassification$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        BinaryClassification.Params params = (BinaryClassification.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(BinaryClassification.Params params) {
        LogisticRegressionModel logisticRegressionModel;
        L1Updater l1Updater;
        SparkConf conf = new SparkConf().setAppName(new StringBuilder(26).append("BinaryClassification with ").append(params).toString());
        SparkContext sc = new SparkContext(conf);
        Configurator.setRootLevel((Level)Level.WARN);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        RDD[] splits = examples.randomSplit(new double[]{0.8, 0.2}, examples.randomSplit$default$2());
        RDD training = splits[0].cache();
        RDD test = splits[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("Training: ").append(numTraining).append(", test: ").append(numTest).append(".").toString());
        examples.unpersist(examples.unpersist$default$1());
        Enumeration.Value value = params.regType();
        Enumeration.Value value2 = BinaryClassification$RegType$.MODULE$.L1();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            l1Updater = new L1Updater();
        } else {
            Enumeration.Value value4 = BinaryClassification$RegType$.MODULE$.L2();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                l1Updater = new SquaredL2Updater();
            } else {
                throw new MatchError((Object)value);
            }
        }
        L1Updater updater = l1Updater;
        Enumeration.Value value6 = params.algorithm();
        Enumeration.Value value7 = BinaryClassification$Algorithm$.MODULE$.LR();
        Enumeration.Value value8 = value6;
        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
            LogisticRegressionWithLBFGS algorithm = new LogisticRegressionWithLBFGS();
            algorithm.optimizer().setNumIterations(params.numIterations()).setUpdater((Updater)updater).setRegParam(params.regParam());
            logisticRegressionModel = algorithm.run(training).clearThreshold();
        } else {
            Enumeration.Value value9 = BinaryClassification$Algorithm$.MODULE$.SVM();
            Enumeration.Value value10 = value6;
            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                SVMWithSGD algorithm = new SVMWithSGD();
                algorithm.optimizer().setNumIterations(params.numIterations()).setStepSize(params.stepSize()).setUpdater((Updater)updater).setRegParam(params.regParam());
                logisticRegressionModel = ((SVMModel)algorithm.run(training)).clearThreshold();
            } else {
                throw new MatchError((Object)value6);
            }
        }
        LogisticRegressionModel model = logisticRegressionModel;
        RDD prediction = model.predict(test.map((Function1 & Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class)));
        RDD predictionAndLabel = prediction.zip(test.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.label()), (ClassTag)ClassTag$.MODULE$.Double()), (ClassTag)ClassTag$.MODULE$.Double());
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(predictionAndLabel);
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("Test areaUnderPR = ").append(metrics.areaUnderPR()).append(".").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Test areaUnderROC = ").append(metrics.areaUnderROC()).append(".").toString());
        sc.stop();
    }

    private BinaryClassification$() {
    }
}

