/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.frame;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public abstract class FrameDecoder
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private boolean unfold;
    protected ChannelBuffer cumulation;
    private volatile ChannelHandlerContext ctx;
    private int copyThreshold;
    private int maxCumulationBufferComponents = 1024;

    protected FrameDecoder() {
        this(false);
    }

    protected FrameDecoder(boolean unfold) {
        this.unfold = unfold;
    }

    public final boolean isUnfold() {
        return this.unfold;
    }

    public final void setUnfold(boolean unfold) {
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.unfold = unfold;
    }

    public final int getMaxCumulationBufferCapacity() {
        return this.copyThreshold;
    }

    public final void setMaxCumulationBufferCapacity(int copyThreshold) {
        if (copyThreshold < 0) {
            throw new IllegalArgumentException("maxCumulationBufferCapacity must be >= 0");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.copyThreshold = copyThreshold;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int maxCumulationBufferComponents) {
        if (maxCumulationBufferComponents < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + maxCumulationBufferComponents + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = maxCumulationBufferComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        block7: {
            Object m = e.getMessage();
            if (!(m instanceof ChannelBuffer)) {
                ctx.sendUpstream(e);
                return;
            }
            ChannelBuffer input2 = (ChannelBuffer)m;
            if (!input2.readable()) {
                return;
            }
            if (this.cumulation == null) {
                try {
                    this.callDecode(ctx, e.getChannel(), input2, e.getRemoteAddress());
                    Object var6_5 = null;
                    this.updateCumulation(ctx, input2);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updateCumulation(ctx, input2);
                    throw throwable;
                }
                {
                    break block7;
                }
            }
            input2 = this.appendToCumulation(input2);
            try {
                this.callDecode(ctx, e.getChannel(), input2, e.getRemoteAddress());
                Object var8_8 = null;
                this.updateCumulation(ctx, input2);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.updateCumulation(ctx, input2);
                throw throwable;
            }
            {
            }
        }
    }

    protected ChannelBuffer appendToCumulation(ChannelBuffer input2) {
        CompositeChannelBuffer composite;
        ChannelBuffer cumulation = this.cumulation;
        assert (cumulation.readable());
        if (cumulation instanceof CompositeChannelBuffer && (composite = (CompositeChannelBuffer)cumulation).numComponents() >= this.maxCumulationBufferComponents) {
            cumulation = composite.copy();
        }
        this.cumulation = input2 = ChannelBuffers.wrappedBuffer(cumulation, input2);
        return input2;
    }

    protected ChannelBuffer updateCumulation(ChannelHandlerContext ctx, ChannelBuffer input2) {
        ChannelBuffer newCumulation;
        int readableBytes = input2.readableBytes();
        if (readableBytes > 0) {
            int inputCapacity = input2.capacity();
            if (readableBytes < inputCapacity && inputCapacity > this.copyThreshold) {
                this.cumulation = newCumulation = this.newCumulationBuffer(ctx, input2.readableBytes());
                this.cumulation.writeBytes(input2);
            } else {
                this.cumulation = input2.readerIndex() != 0 ? (newCumulation = input2.slice()) : (newCumulation = input2);
            }
        } else {
            newCumulation = null;
            this.cumulation = null;
        }
        return newCumulation;
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer);
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer cumulation, SocketAddress remoteAddress) throws Exception {
        while (cumulation.readable()) {
            int oldReaderIndex = cumulation.readerIndex();
            Object frame = this.decode(context, channel, cumulation);
            if (frame == null) {
                if (oldReaderIndex != cumulation.readerIndex()) continue;
                break;
            }
            if (oldReaderIndex == cumulation.readerIndex()) {
                throw new IllegalStateException("decode() method must read at least one byte if it returned a frame (caused by: " + this.getClass() + ')');
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, frame);
        }
    }

    protected final void unfoldAndFireMessageReceived(ChannelHandlerContext context, SocketAddress remoteAddress, Object result2) {
        if (this.unfold) {
            if (result2 instanceof Object[]) {
                for (Object r : (Object[])result2) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else if (result2 instanceof Iterable) {
                for (Object r : (Iterable)result2) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else {
                Channels.fireMessageReceived(context, result2, remoteAddress);
            }
        } else {
            Channels.fireMessageReceived(context, result2, remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Object partialFrame;
            ChannelBuffer cumulation = this.cumulation;
            if (cumulation == null) {
                Object var6_4 = null;
                ctx.sendUpstream(e);
                return;
            }
            this.cumulation = null;
            if (cumulation.readable()) {
                this.callDecode(ctx, ctx.getChannel(), cumulation, null);
            }
            if ((partialFrame = this.decodeLast(ctx, ctx.getChannel(), cumulation)) != null) {
                this.unfoldAndFireMessageReceived(ctx, null, partialFrame);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ctx.sendUpstream(e);
            throw throwable;
        }
        Object var6_5 = null;
        ctx.sendUpstream(e);
    }

    protected ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
        return factory.getBuffer(Math.max(minimumCapacity, 256));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String handlerName, ChannelHandler handler) {
        if (this.ctx == null) {
            throw new IllegalStateException("Replace cann only be called once the FrameDecoder is added to the ChannelPipeline");
        }
        ChannelPipeline pipeline = this.ctx.getPipeline();
        pipeline.addAfter(this.ctx.getName(), handlerName, handler);
        try {
            if (this.cumulation != null) {
                Channels.fireMessageReceived(this.ctx, (Object)this.cumulation.readBytes(this.actualReadableBytes()));
            }
            Object var5_4 = null;
            pipeline.remove(this);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            pipeline.remove(this);
            throw throwable;
        }
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ChannelBuffer internalBuffer() {
        ChannelBuffer buf = this.cumulation;
        if (buf == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return buf;
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index2, int length) {
        ChannelBuffer frame = buffer.factory().getBuffer(length);
        frame.writeBytes(buffer, index2, length);
        return frame;
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

