/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.integration.spring;

import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ValidationFailedException;
import net.sf.oval.internal.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

public class SpringValidator
implements org.springframework.validation.Validator,
InitializingBean {
    private static final Log LOG = Log.getLog(SpringValidator.class);
    private Validator validator;

    public SpringValidator() {
    }

    public SpringValidator(Validator validator) {
        this.validator = validator;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.validator, (String)"Property [validator] must be set");
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public void validate(Object objectToValidate, Errors errors) {
        try {
            for (ConstraintViolation violation : this.validator.validate(objectToValidate)) {
                OValContext ctx = violation.getContext();
                String errorCode = violation.getErrorCode();
                String errorMessage = violation.getMessage();
                if (ctx instanceof FieldContext) {
                    String fieldName = ((FieldContext)ctx).getField().getName();
                    errors.rejectValue(fieldName, errorCode, errorMessage);
                    continue;
                }
                errors.reject(errorCode, errorMessage);
            }
        }
        catch (ValidationFailedException ex) {
            LOG.error("Unexpected error during validation", ex);
            errors.reject(ex.getMessage());
        }
    }
}

