/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.interceptor.ValidationAware;
import org.apache.struts2.text.TextProvider;

public final class DebugUtils {
    private static final Set<String> IS_LOGGED = ConcurrentHashMap.newKeySet();

    public static void notifyDeveloperOfError(Logger log, Object action, String message) {
        if (action instanceof TextProvider) {
            TextProvider tp = (TextProvider)action;
            message = tp.getText("devmode.notification", "Developer Notification:\n{0}", new String[]{message});
        }
        log.error(message);
        if (action instanceof ValidationAware) {
            ValidationAware validationAware = (ValidationAware)action;
            validationAware.addActionError(message);
        }
    }

    public static void logWarningForFirstOccurrence(String key, Logger log, String msg, Object ... args) {
        if (IS_LOGGED.add(key)) {
            log.warn(msg, args);
        }
    }
}

