/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TrustException
extends Exception {
    private static final long serialVersionUID = -445341784514373965L;
    public static final String INVALID_REQUEST = "InvalidRequest";
    public static final String FAILED_AUTHENTICATION = "FailedAuthentication";
    public static final String REQUEST_FAILED = "RequestFailed";
    public static final String INVALID_SECURITY_TOKEN = "InvalidSecurityToken";
    public static final String AUTHENTICATION_BAD_ELEMENTS = "AuthenticationBadElements";
    public static final String BAD_REQUEST = "BadRequest";
    public static final String EXPIRED_DATA = "ExpiredData";
    public static final String INVALID_TIME_RANGE = "InvalidTimeRange";
    public static final String INVALID_SCOPE = "InvalidScope";
    public static final String RENEW_NEEDED = "RenewNeeded";
    public static final String UNABLE_TO_RENEW = "UnableToRenew";
    private static ResourceBundle resources;
    private String faultCode;
    private String faultString;

    public TrustException(String faultCode, Object[] args) {
        super(TrustException.getMessage(faultCode, args));
        this.faultCode = this.getFaultCode(faultCode);
        this.faultString = TrustException.getMessage(faultCode, args);
    }

    private String getFaultCode(String code) {
        if (AUTHENTICATION_BAD_ELEMENTS.equals(code) || BAD_REQUEST.equals(code) || EXPIRED_DATA.equals(code) || FAILED_AUTHENTICATION.equals(code) || INVALID_REQUEST.equals(code) || INVALID_SCOPE.equals(code) || INVALID_SECURITY_TOKEN.equals(code) || INVALID_TIME_RANGE.equals(code) || RENEW_NEEDED.equals(code) || REQUEST_FAILED.equals(code) || UNABLE_TO_RENEW.equals(code)) {
            return "wst:" + code;
        }
        return code;
    }

    public TrustException(String faultCode) {
        this(faultCode, (Object[])null);
    }

    public TrustException(String faultCode, Object[] args, Throwable e) {
        super(TrustException.getMessage(faultCode, args), e);
        this.faultCode = faultCode;
        this.faultString = TrustException.getMessage(faultCode, args);
    }

    public TrustException(String faultCode, Throwable e) {
        this(faultCode, null, e);
    }

    protected static String getMessage(String faultCode, Object[] args) {
        String msg = null;
        try {
            msg = MessageFormat.format(resources.getString(faultCode), args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Undefined '" + faultCode + "' resource property");
        }
        if (msg != null) {
            return msg;
        }
        return faultCode;
    }

    protected String getFaultCode() {
        return this.faultCode;
    }

    protected String getFaultString() {
        return this.faultString;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("org.apache.rahas.errors");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

