/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;

public class TaskDescriptionRepository {
    private static final Log log = LogFactory.getLog(TaskDescriptionRepository.class);
    private final Map<String, TaskDescription> taskDescriptionMap = new HashMap<String, TaskDescription>();

    public void addTaskDescription(TaskDescription taskDescription) {
        this.validateTaskDescription(taskDescription);
        String name = taskDescription.getName();
        this.validateName(name);
        this.validateUniqueness(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing a TaskDescription : " + taskDescription));
        }
        this.taskDescriptionMap.put(name, taskDescription);
    }

    public TaskDescription getTaskDescription(String name) {
        this.validateName(name);
        TaskDescription taskDescription = this.taskDescriptionMap.get(name);
        if (taskDescription == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("TaskDescription cannot be found for name :" + name + " , returning null"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Returning TaskDescription : " + taskDescription));
        }
        return taskDescription;
    }

    public TaskDescription removeTaskDescription(String name) {
        TaskDescription taskDescription;
        this.validateName(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing a TaskDescription with name : " + name));
        }
        if ((taskDescription = this.taskDescriptionMap.remove(name)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no TaskDescription to be removed with name : " + name));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Removed TaskDescription : " + taskDescription));
        }
        return taskDescription;
    }

    public Iterator<TaskDescription> getAllTaskDescriptions() {
        return this.taskDescriptionMap.values().iterator();
    }

    public boolean isUnique(String name) {
        this.validateName(name);
        return this.taskDescriptionMap.isEmpty() || !this.taskDescriptionMap.containsKey(name);
    }

    public void clear() {
        this.taskDescriptionMap.clear();
    }

    private void validateName(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseTaskException("Task name is null or empty", log);
        }
    }

    private void validateUniqueness(String name) {
        if (this.taskDescriptionMap.containsKey(name)) {
            throw new SynapseTaskException("Name with ' " + name + " ' is already there", log);
        }
    }

    private void validateTaskDescription(TaskDescription taskDescription) {
        if (taskDescription == null) {
            throw new SynapseTaskException("TaskDescription is null", log);
        }
    }
}

