/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetAndTimestampInternal;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class OffsetsRequestManagerTest {
    private OffsetsRequestManager requestManager;
    private ConsumerMetadata metadata;
    private SubscriptionState subscriptionState;
    private MockTime time;
    private ApiVersions apiVersions;
    private BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private static final String TEST_TOPIC = "t1";
    private static final TopicPartition TEST_PARTITION_1 = new TopicPartition("t1", 1);
    private static final TopicPartition TEST_PARTITION_2 = new TopicPartition("t1", 2);
    private static final Node LEADER_1 = new Node(0, "host1", 9092);
    private static final Node LEADER_2 = new Node(0, "host2", 9092);
    private static final IsolationLevel DEFAULT_ISOLATION_LEVEL = IsolationLevel.READ_COMMITTED;
    private static final int RETRY_BACKOFF_MS = 500;
    private static final int REQUEST_TIMEOUT_MS = 500;

    @BeforeEach
    public void setup() {
        LogContext logContext = new LogContext();
        this.backgroundEventQueue = new LinkedBlockingQueue<BackgroundEvent>();
        BackgroundEventHandler backgroundEventHandler = new BackgroundEventHandler(this.backgroundEventQueue);
        this.metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
        this.subscriptionState = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.time = new MockTime(0L);
        this.apiVersions = (ApiVersions)Mockito.mock(ApiVersions.class);
        this.requestManager = new OffsetsRequestManager(this.subscriptionState, this.metadata, DEFAULT_ISOLATION_LEVEL, (Time)this.time, 500L, 500L, this.apiVersions, (NetworkClientDelegate)Mockito.mock(NetworkClientDelegate.class), backgroundEventHandler, logContext);
    }

    @Test
    public void testListOffsetsRequest_Success() throws ExecutionException, InterruptedException {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture result = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Map<TopicPartition, OffsetAndTimestampInternal> expectedOffsets = Collections.singletonMap(TEST_PARTITION_1, new OffsetAndTimestampInternal(5L, -1L, Optional.empty()));
        this.verifySuccessfulPollAndResponseReceived(result, expectedOffsets);
    }

    @Test
    public void testListOffsetsWaitingForMetadataUpdate_Timeout() {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockFailedRequest_MissingLeader();
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToRetry());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(true);
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)res.unsentRequests.size());
        Assertions.assertThrows(TimeoutException.class, () -> {
            Map cfr_ignored_0 = (Map)fetchOffsetsFuture.get(5L, TimeUnit.MILLISECONDS);
        });
    }

    @Test
    public void testListOffsetsRequestMultiplePartitions() throws ExecutionException, InterruptedException {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(TEST_PARTITION_1, -2L);
        timestampsToSearch.put(TEST_PARTITION_2, -2L);
        HashMap<TopicPartition, Node> partitionLeaders = new HashMap<TopicPartition, Node>();
        partitionLeaders.put(TEST_PARTITION_1, LEADER_1);
        partitionLeaders.put(TEST_PARTITION_2, LEADER_1);
        this.mockSuccessfulRequest(partitionLeaders);
        CompletableFuture result = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Map<TopicPartition, OffsetAndTimestampInternal> expectedOffsets = timestampsToSearch.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OffsetAndTimestampInternal(5L, -1L, Optional.empty())));
        this.verifySuccessfulPollAndResponseReceived(result, expectedOffsets);
    }

    @Test
    public void testListOffsetsRequestEmpty() throws ExecutionException, InterruptedException {
        CompletableFuture result = this.requestManager.fetchOffsets(Collections.emptyMap(), false);
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult pollResult = this.requestManager.poll(this.time.milliseconds());
        Assertions.assertTrue((boolean)pollResult.unsentRequests.isEmpty());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertTrue((boolean)result.isDone());
        Assertions.assertFalse((boolean)result.isCompletedExceptionally());
        Assertions.assertTrue((boolean)((Map)result.get()).isEmpty());
    }

    @Test
    public void testListOffsetsRequestUnknownOffset() throws ExecutionException, InterruptedException {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture result = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        List<ListOffsetsResponseData.ListOffsetsTopicResponse> topicResponses = Collections.singletonList(this.mockUnknownOffsetResponse(TEST_PARTITION_1));
        NetworkClientDelegate.PollResult retriedPoll = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(retriedPoll);
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)retriedPoll.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponse(unsentRequest, topicResponses);
        clientResponse.onComplete();
        Map<TopicPartition, Object> expectedOffsets = Collections.singletonMap(TEST_PARTITION_1, null);
        this.verifyRequestSuccessfullyCompleted(result, expectedOffsets);
    }

    @Test
    public void testListOffsetsWaitingForMetadataUpdate_RetrySucceeds() throws ExecutionException, InterruptedException {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockFailedRequest_MissingLeader();
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToRetry());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(true);
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)res.unsentRequests.size());
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        this.requestManager.onUpdate(new ClusterResource(""));
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Map<TopicPartition, OffsetAndTimestampInternal> expectedOffsets = Collections.singletonMap(TEST_PARTITION_1, new OffsetAndTimestampInternal(5L, -1L, Optional.empty()));
        this.verifySuccessfulPollAndResponseReceived(fetchOffsetsFuture, expectedOffsets);
    }

    @ParameterizedTest
    @MethodSource(value={"retriableErrors"})
    public void testRequestFailsWithRetriableError_RetrySucceeds(Errors error) throws ExecutionException, InterruptedException {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(res);
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponseWithErrors(unsentRequest, Collections.singletonMap(TEST_PARTITION_1, error));
        clientResponse.onComplete();
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        this.requestManager.onUpdate(new ClusterResource(""));
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Map<TopicPartition, OffsetAndTimestampInternal> expectedOffsets = Collections.singletonMap(TEST_PARTITION_1, new OffsetAndTimestampInternal(5L, -1L, Optional.empty()));
        this.verifySuccessfulPollAndResponseReceived(fetchOffsetsFuture, expectedOffsets);
    }

    @Test
    public void testRequestNotSupportedErrorReturnsNullOffset() throws ExecutionException, InterruptedException {
        this.testResponseWithErrorCodeAndUnknownOffsets(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    @Test
    public void testRequestWithUnknownOffsetInResponseReturnsNullOffset() throws ExecutionException, InterruptedException {
        this.testResponseWithErrorCodeAndUnknownOffsets(Errors.NONE);
    }

    private void testResponseWithErrorCodeAndUnknownOffsets(Errors error) throws ExecutionException, InterruptedException {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(res);
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponseWithErrors(unsentRequest, Collections.singletonMap(TEST_PARTITION_1, error));
        clientResponse.onComplete();
        Map<TopicPartition, Object> expectedOffsets = Collections.singletonMap(TEST_PARTITION_1, null);
        this.verifyRequestSuccessfullyCompleted(fetchOffsetsFuture, expectedOffsets);
    }

    @Test
    public void testRequestPartiallyFailsWithRetriableError_RetrySucceeds() throws ExecutionException, InterruptedException {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(TEST_PARTITION_1, -2L);
        timestampsToSearch.put(TEST_PARTITION_2, -2L);
        Map<TopicPartition, OffsetAndTimestampInternal> expectedOffsets = timestampsToSearch.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new OffsetAndTimestampInternal(5L, -1L, Optional.empty())));
        HashMap<TopicPartition, Node> partitionLeaders = new HashMap<TopicPartition, Node>();
        partitionLeaders.put(TEST_PARTITION_1, LEADER_1);
        partitionLeaders.put(TEST_PARTITION_2, LEADER_2);
        this.mockSuccessfulRequest(partitionLeaders);
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)2, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(res, 2);
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        NetworkClientDelegate.UnsentRequest unsentRequest1 = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        long offsets = expectedOffsets.get(TEST_PARTITION_1).offset();
        ClientResponse clientResponse1 = this.buildClientResponse(unsentRequest1, Collections.singletonMap(TEST_PARTITION_1, new OffsetAndTimestampInternal(offsets, -1L, Optional.empty())));
        clientResponse1.onComplete();
        NetworkClientDelegate.UnsentRequest unsentRequest2 = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(1);
        ClientResponse clientResponse2 = this.buildClientResponseWithErrors(unsentRequest2, Collections.singletonMap(TEST_PARTITION_2, Errors.UNKNOWN_LEADER_EPOCH));
        clientResponse2.onComplete();
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        this.mockSuccessfulRequest(partitionLeaders);
        this.requestManager.onUpdate(new ClusterResource(""));
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        NetworkClientDelegate.PollResult retriedPoll = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(retriedPoll);
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)retriedPoll.unsentRequests.get(0);
        long offsets2 = expectedOffsets.get(TEST_PARTITION_2).offset();
        ClientResponse clientResponse = this.buildClientResponse(unsentRequest, Collections.singletonMap(TEST_PARTITION_2, new OffsetAndTimestampInternal(offsets2, -1L, Optional.empty())));
        clientResponse.onComplete();
        this.verifyRequestSuccessfullyCompleted(fetchOffsetsFuture, expectedOffsets);
    }

    @Test
    public void testRequestFailedResponse_NonRetriableAuthError() {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(res);
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponseWithErrors(unsentRequest, Collections.singletonMap(TEST_PARTITION_2, Errors.TOPIC_AUTHORIZATION_FAILED));
        clientResponse.onComplete();
        this.verifyRequestCompletedWithErrorResponse(fetchOffsetsFuture, TopicAuthorizationException.class);
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testRequestFailedResponse_NonRetriableErrorTimeout() {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(res);
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponseWithErrors(unsentRequest, Collections.singletonMap(TEST_PARTITION_2, Errors.BROKER_NOT_AVAILABLE));
        clientResponse.onComplete();
        Assertions.assertFalse((boolean)fetchOffsetsFuture.isDone());
        Assertions.assertThrows(TimeoutException.class, () -> {
            Map cfr_ignored_0 = (Map)fetchOffsetsFuture.get(5L, TimeUnit.MILLISECONDS);
        });
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testRequestFails_AuthenticationException() {
        Map<TopicPartition, Long> timestampsToSearch = Collections.singletonMap(TEST_PARTITION_1, -2L);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        CompletableFuture fetchOffsetsFuture = this.requestManager.fetchOffsets(timestampsToSearch, false);
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(res);
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponse(unsentRequest, Collections.emptyList(), false, new AuthenticationException("Authentication failed"));
        clientResponse.onComplete();
        Assertions.assertTrue((boolean)fetchOffsetsFuture.isCompletedExceptionally());
        Throwable failure = Assertions.assertThrows(ExecutionException.class, fetchOffsetsFuture::get);
        Assertions.assertEquals(AuthenticationException.class, failure.getCause().getClass());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testResetPositionsSendNoRequestIfNoPartitionsNeedingReset() {
        Mockito.when((Object)this.subscriptionState.partitionsNeedingReset(this.time.milliseconds())).thenReturn(Collections.emptySet());
        this.requestManager.resetPositionsIfNeeded();
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testResetPositionsMissingLeader() {
        this.mockFailedRequest_MissingLeader();
        Mockito.when((Object)this.subscriptionState.partitionsNeedingReset(this.time.milliseconds())).thenReturn(Collections.singleton(TEST_PARTITION_1));
        Mockito.when((Object)this.subscriptionState.resetStrategy((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)OffsetResetStrategy.EARLIEST);
        this.requestManager.resetPositionsIfNeeded();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(true);
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testResetPositionsSuccess_NoLeaderEpochInResponse() {
        this.testResetPositionsSuccessWithLeaderEpoch(Metadata.LeaderAndEpoch.noLeaderOrEpoch());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.never())).updateLastSeenEpochIfNewer((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void testResetPositionsSuccess_LeaderEpochInResponse() {
        Metadata.LeaderAndEpoch leaderAndEpoch = new Metadata.LeaderAndEpoch(Optional.of(LEADER_1), Optional.of(5));
        this.testResetPositionsSuccessWithLeaderEpoch(leaderAndEpoch);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).updateLastSeenEpochIfNewer(TEST_PARTITION_1, ((Integer)leaderAndEpoch.epoch.get()).intValue());
    }

    @Test
    public void testResetOffsetsAuthorizationFailure() {
        Mockito.when((Object)this.subscriptionState.partitionsNeedingReset(this.time.milliseconds())).thenReturn(Collections.singleton(TEST_PARTITION_1));
        Mockito.when((Object)this.subscriptionState.resetStrategy((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)OffsetResetStrategy.EARLIEST);
        this.mockSuccessfulRequest(Collections.singletonMap(TEST_PARTITION_1, LEADER_1));
        this.requestManager.resetPositionsIfNeeded();
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        Errors topicAuthorizationFailedError = Errors.TOPIC_AUTHORIZATION_FAILED;
        ClientResponse clientResponse = this.buildClientResponseWithErrors(unsentRequest, Collections.singletonMap(TEST_PARTITION_1, topicAuthorizationFailedError));
        clientResponse.onComplete();
        Assertions.assertTrue((boolean)unsentRequest.future().isDone());
        Assertions.assertFalse((boolean)unsentRequest.future().isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).requestFailed((Set)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(false);
        Assertions.assertDoesNotThrow(() -> this.requestManager.resetPositionsIfNeeded());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)1, (int)this.backgroundEventQueue.size());
        BackgroundEvent event = (BackgroundEvent)this.backgroundEventQueue.poll();
        Assertions.assertNotNull((Object)event);
        Assertions.assertInstanceOf(ErrorEvent.class, (Object)event);
        ErrorEvent errorEvent = (ErrorEvent)event;
        Assertions.assertNotNull((Object)errorEvent.error());
        Assertions.assertInstanceOf(topicAuthorizationFailedError.exception().getClass(), (Object)errorEvent.error());
    }

    @Test
    public void testValidatePositionsSuccess() {
        int currentOffset = 5;
        int expectedEndOffset = 100;
        Metadata.LeaderAndEpoch leaderAndEpoch = new Metadata.LeaderAndEpoch(Optional.of(LEADER_1), Optional.of(3));
        TopicPartition tp = TEST_PARTITION_1;
        SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition((long)currentOffset, Optional.of(10), leaderAndEpoch);
        this.mockSuccessfulBuildRequestForValidatingPositions(position, LEADER_1);
        this.requestManager.validatePositionsIfNeeded();
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend(), (String)"Invalid request count");
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).setNextAllowedRetry((Set)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        Mockito.when((Object)this.metadata.currentLeader(tp)).thenReturn((Object)this.testLeaderEpoch(LEADER_1, leaderAndEpoch.epoch));
        NetworkClientDelegate.PollResult pollResult = this.requestManager.poll(this.time.milliseconds());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildOffsetsForLeaderEpochResponse(unsentRequest, Collections.singletonList(tp), expectedEndOffset);
        clientResponse.onComplete();
        Assertions.assertTrue((boolean)unsentRequest.future().isDone());
        Assertions.assertFalse((boolean)unsentRequest.future().isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).maybeCompleteValidation((TopicPartition)ArgumentMatchers.any(), (SubscriptionState.FetchPosition)ArgumentMatchers.any(), (OffsetForLeaderEpochResponseData.EpochEndOffset)ArgumentMatchers.any());
    }

    @Test
    public void testValidatePositionsMissingLeader() {
        Metadata.LeaderAndEpoch leaderAndEpoch = new Metadata.LeaderAndEpoch(Optional.of(Node.noNode()), Optional.of(5));
        SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition(5L, Optional.of(10), leaderAndEpoch);
        Mockito.when((Object)this.subscriptionState.partitionsNeedingValidation(this.time.milliseconds())).thenReturn(Collections.singleton(TEST_PARTITION_1));
        Mockito.when((Object)this.subscriptionState.position((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)position, (Object[])new SubscriptionState.FetchPosition[]{position});
        NodeApiVersions nodeApiVersions = NodeApiVersions.create();
        Mockito.when((Object)this.apiVersions.get(LEADER_1.idString())).thenReturn((Object)nodeApiVersions);
        this.requestManager.validatePositionsIfNeeded();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(true);
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testValidatePositionsFailureWithUnrecoverableAuthException() {
        Metadata.LeaderAndEpoch leaderAndEpoch = new Metadata.LeaderAndEpoch(Optional.of(LEADER_1), Optional.of(5));
        SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition(5L, Optional.of(10), leaderAndEpoch);
        this.mockSuccessfulBuildRequestForValidatingPositions(position, LEADER_1);
        this.requestManager.validatePositionsIfNeeded();
        NetworkClientDelegate.PollResult res = this.requestManager.poll(this.time.milliseconds());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildOffsetsForLeaderEpochResponseWithErrors(unsentRequest, Collections.singletonMap(TEST_PARTITION_1, Errors.TOPIC_AUTHORIZATION_FAILED));
        clientResponse.onComplete();
        Assertions.assertTrue((boolean)unsentRequest.future().isDone());
        Assertions.assertFalse((boolean)unsentRequest.future().isCompletedExceptionally());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> this.requestManager.validatePositionsIfNeeded());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
    }

    @Test
    public void testValidatePositionsAbortIfNoApiVersionsToCheckAgainstThenRecovers() {
        int currentOffset = 5;
        Metadata.LeaderAndEpoch leaderAndEpoch = new Metadata.LeaderAndEpoch(Optional.of(LEADER_1), Optional.of(3));
        SubscriptionState.FetchPosition position = new SubscriptionState.FetchPosition((long)currentOffset, Optional.of(10), leaderAndEpoch);
        Mockito.when((Object)this.subscriptionState.partitionsNeedingValidation(this.time.milliseconds())).thenReturn(Collections.singleton(TEST_PARTITION_1));
        Mockito.when((Object)this.subscriptionState.position((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)position, (Object[])new SubscriptionState.FetchPosition[]{position});
        Mockito.when((Object)this.apiVersions.get(LEADER_1.idString())).thenReturn(null);
        this.requestManager.validatePositionsIfNeeded();
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend(), (String)"Invalid request count");
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).completeValidation(TEST_PARTITION_1);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).setNextAllowedRetry((Set)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        Mockito.when((Object)this.apiVersions.get(LEADER_1.idString())).thenReturn((Object)NodeApiVersions.create());
        Mockito.when((Object)this.subscriptionState.partitionsNeedingValidation(this.time.milliseconds())).thenReturn(Collections.singleton(TEST_PARTITION_1));
        Mockito.when((Object)this.subscriptionState.position((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)position, (Object[])new SubscriptionState.FetchPosition[]{position});
        this.requestManager.validatePositionsIfNeeded();
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend(), (String)"Invalid request count");
    }

    private void mockSuccessfulBuildRequestForValidatingPositions(SubscriptionState.FetchPosition position, Node leader) {
        Mockito.when((Object)this.subscriptionState.partitionsNeedingValidation(this.time.milliseconds())).thenReturn(Collections.singleton(TEST_PARTITION_1));
        Mockito.when((Object)this.subscriptionState.position((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)position, (Object[])new SubscriptionState.FetchPosition[]{position});
        NodeApiVersions nodeApiVersions = NodeApiVersions.create();
        Mockito.when((Object)this.apiVersions.get(leader.idString())).thenReturn((Object)nodeApiVersions);
    }

    private void testResetPositionsSuccessWithLeaderEpoch(Metadata.LeaderAndEpoch leaderAndEpoch) {
        TopicPartition tp = TEST_PARTITION_1;
        Node leader = LEADER_1;
        OffsetResetStrategy strategy = OffsetResetStrategy.EARLIEST;
        long offset = 5L;
        Mockito.when((Object)this.subscriptionState.partitionsNeedingReset(this.time.milliseconds())).thenReturn(Collections.singleton(tp));
        Mockito.when((Object)this.subscriptionState.resetStrategy((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)strategy);
        this.mockSuccessfulRequest(Collections.singletonMap(tp, leader));
        this.requestManager.resetPositionsIfNeeded();
        Assertions.assertEquals((int)1, (int)this.requestManager.requestsToSend());
        Mockito.when((Object)this.metadata.currentLeader(tp)).thenReturn((Object)this.testLeaderEpoch(leader, leaderAndEpoch.epoch));
        NetworkClientDelegate.PollResult pollResult = this.requestManager.poll(this.time.milliseconds());
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponse(unsentRequest, Collections.singletonMap(tp, new OffsetAndTimestampInternal(offset, 1L, leaderAndEpoch.epoch)));
        clientResponse.onComplete();
        Assertions.assertTrue((boolean)unsentRequest.future().isDone());
        Assertions.assertFalse((boolean)unsentRequest.future().isCompletedExceptionally());
    }

    private ListOffsetsResponseData.ListOffsetsTopicResponse mockUnknownOffsetResponse(TopicPartition tp) {
        return new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(tp.topic()).setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(tp.partition()).setErrorCode(Errors.NONE.code()).setTimestamp(-1L).setOffset(-1L)));
    }

    private static Stream<Arguments> retriableErrors() {
        return Stream.of(Arguments.of((Object[])new Object[]{Errors.NOT_LEADER_OR_FOLLOWER}), Arguments.of((Object[])new Object[]{Errors.REPLICA_NOT_AVAILABLE}), Arguments.of((Object[])new Object[]{Errors.KAFKA_STORAGE_ERROR}), Arguments.of((Object[])new Object[]{Errors.OFFSET_NOT_AVAILABLE}), Arguments.of((Object[])new Object[]{Errors.LEADER_NOT_AVAILABLE}), Arguments.of((Object[])new Object[]{Errors.FENCED_LEADER_EPOCH}), Arguments.of((Object[])new Object[]{Errors.BROKER_NOT_AVAILABLE}), Arguments.of((Object[])new Object[]{Errors.INVALID_REQUEST}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_LEADER_EPOCH}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION}));
    }

    private void verifySuccessfulPollAndResponseReceived(CompletableFuture<Map<TopicPartition, OffsetAndTimestampInternal>> actualResult, Map<TopicPartition, OffsetAndTimestampInternal> expectedResult) throws ExecutionException, InterruptedException {
        NetworkClientDelegate.PollResult retriedPoll = this.requestManager.poll(this.time.milliseconds());
        this.verifySuccessfulPollAwaitingResponse(retriedPoll);
        NetworkClientDelegate.UnsentRequest unsentRequest = (NetworkClientDelegate.UnsentRequest)retriedPoll.unsentRequests.get(0);
        ClientResponse clientResponse = this.buildClientResponse(unsentRequest, expectedResult);
        clientResponse.onComplete();
        this.verifyRequestSuccessfullyCompleted(actualResult, expectedResult);
    }

    private void verifyRequestCompletedWithErrorResponse(CompletableFuture<Map<TopicPartition, OffsetAndTimestampInternal>> actualResult, Class<? extends Throwable> expectedFailure) {
        Assertions.assertTrue((boolean)actualResult.isDone());
        Assertions.assertTrue((boolean)actualResult.isCompletedExceptionally());
        Throwable failure = Assertions.assertThrows(ExecutionException.class, actualResult::get);
        Assertions.assertEquals(expectedFailure, failure.getCause().getClass());
    }

    private void mockSuccessfulRequest(Map<TopicPartition, Node> partitionLeaders) {
        partitionLeaders.forEach((tp, broker) -> {
            Mockito.when((Object)this.metadata.currentLeader(tp)).thenReturn((Object)this.testLeaderEpoch((Node)broker, Metadata.LeaderAndEpoch.noLeaderOrEpoch().epoch));
            Mockito.when((Object)this.subscriptionState.isAssigned(tp)).thenReturn((Object)true);
        });
        Mockito.when((Object)this.metadata.fetch()).thenReturn((Object)this.testClusterMetadata(partitionLeaders));
    }

    private void mockFailedRequest_MissingLeader() {
        Mockito.when((Object)this.metadata.currentLeader((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenReturn((Object)new Metadata.LeaderAndEpoch(Optional.empty(), Optional.of(1)));
        Mockito.when((Object)this.subscriptionState.isAssigned((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenReturn((Object)true);
    }

    private void verifySuccessfulPollAwaitingResponse(NetworkClientDelegate.PollResult pollResult) {
        this.verifySuccessfulPollAwaitingResponse(pollResult, 1);
    }

    private void verifySuccessfulPollAwaitingResponse(NetworkClientDelegate.PollResult pollResult, int requestCount) {
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)requestCount, (int)pollResult.unsentRequests.size());
    }

    private void verifyRequestSuccessfullyCompleted(CompletableFuture<Map<TopicPartition, OffsetAndTimestampInternal>> actualResult, Map<TopicPartition, OffsetAndTimestampInternal> expectedResult) throws ExecutionException, InterruptedException {
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToRetry());
        Assertions.assertEquals((int)0, (int)this.requestManager.requestsToSend());
        Assertions.assertTrue((boolean)actualResult.isDone());
        Assertions.assertFalse((boolean)actualResult.isCompletedExceptionally());
        Map<TopicPartition, OffsetAndTimestampInternal> partitionOffsets = actualResult.get();
        Assertions.assertEquals(expectedResult, partitionOffsets);
        Map<TopicPartition, Long> validExpectedOffsets = expectedResult.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, v -> ((OffsetAndTimestampInternal)v.getValue()).offset()));
        this.verifySubscriptionStateUpdated(validExpectedOffsets);
    }

    private void verifySubscriptionStateUpdated(Map<TopicPartition, Long> expectedResult) {
        ArgumentCaptor tpCaptor = ArgumentCaptor.forClass(TopicPartition.class);
        ArgumentCaptor offsetCaptor = ArgumentCaptor.forClass(Long.class);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.times((int)expectedResult.size()))).updateLastStableOffset((TopicPartition)tpCaptor.capture(), ((Long)offsetCaptor.capture()).longValue());
        List updatedTp = tpCaptor.getAllValues();
        List updatedOffsets = offsetCaptor.getAllValues();
        Assertions.assertEquals((int)expectedResult.keySet().size(), (int)updatedOffsets.size());
        Assertions.assertEquals(expectedResult.keySet(), new HashSet(updatedTp));
        Assertions.assertEquals((int)expectedResult.values().size(), (int)updatedOffsets.size());
        expectedResult.values().stream().map(updatedOffsets::contains).forEach(Assertions::assertTrue);
    }

    private Metadata.LeaderAndEpoch testLeaderEpoch(Node leader, Optional<Integer> epoch) {
        return new Metadata.LeaderAndEpoch(Optional.of(leader), epoch);
    }

    private Cluster testClusterMetadata(Map<TopicPartition, Node> partitionLeaders) {
        List partitions = partitionLeaders.keySet().stream().map(tp -> new PartitionInfo(tp.topic(), tp.partition(), (Node)partitionLeaders.get(tp), null, null)).collect(Collectors.toList());
        return new Cluster("clusterId", partitionLeaders.values(), partitions, Collections.emptySet(), Collections.emptySet());
    }

    private ClientResponse buildClientResponse(NetworkClientDelegate.UnsentRequest request, Map<TopicPartition, OffsetAndTimestampInternal> partitionsOffsets) {
        ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse> topicResponses = new ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse>();
        partitionsOffsets.forEach((tp, offsetAndTimestamp) -> {
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp, (Errors)Errors.NONE, (long)offsetAndTimestamp.timestamp(), (long)offsetAndTimestamp.offset(), (int)offsetAndTimestamp.leaderEpoch().orElse(-1));
            topicResponses.add(topicResponse);
        });
        return this.buildClientResponse(request, topicResponses, false, null);
    }

    private ClientResponse buildOffsetsForLeaderEpochResponse(NetworkClientDelegate.UnsentRequest request, List<TopicPartition> partitions, int endOffset) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertInstanceOf(OffsetsForLeaderEpochRequest.class, (Object)abstractRequest);
        OffsetsForLeaderEpochRequest offsetsForLeaderEpochRequest = (OffsetsForLeaderEpochRequest)abstractRequest;
        OffsetForLeaderEpochResponseData data = new OffsetForLeaderEpochResponseData();
        partitions.forEach(tp -> {
            OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult topic = data.topics().find(tp.topic());
            if (topic == null) {
                topic = new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic());
                data.topics().add((ImplicitLinkedHashCollection.Element)topic);
            }
            topic.partitions().add(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(3).setEndOffset((long)endOffset));
        });
        OffsetsForLeaderEpochResponse response = new OffsetsForLeaderEpochResponse(data);
        return new ClientResponse(new RequestHeader(ApiKeys.OFFSET_FOR_LEADER_EPOCH, offsetsForLeaderEpochRequest.version(), "", 1), (RequestCompletionHandler)request.handler(), "-1", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)response);
    }

    private ClientResponse buildOffsetsForLeaderEpochResponseWithErrors(NetworkClientDelegate.UnsentRequest request, Map<TopicPartition, Errors> partitionErrors) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertInstanceOf(OffsetsForLeaderEpochRequest.class, (Object)abstractRequest);
        OffsetsForLeaderEpochRequest offsetsForLeaderEpochRequest = (OffsetsForLeaderEpochRequest)abstractRequest;
        OffsetForLeaderEpochResponseData data = new OffsetForLeaderEpochResponseData();
        partitionErrors.keySet().forEach(tp -> {
            OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult topic = data.topics().find(tp.topic());
            if (topic == null) {
                topic = new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic());
                data.topics().add((ImplicitLinkedHashCollection.Element)topic);
            }
            topic.partitions().add(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(((Errors)partitionErrors.get(tp)).code()));
        });
        OffsetsForLeaderEpochResponse response = new OffsetsForLeaderEpochResponse(data);
        return new ClientResponse(new RequestHeader(ApiKeys.OFFSET_FOR_LEADER_EPOCH, offsetsForLeaderEpochRequest.version(), "", 1), (RequestCompletionHandler)request.handler(), "-1", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)response);
    }

    private ClientResponse buildClientResponse(NetworkClientDelegate.UnsentRequest request, List<ListOffsetsResponseData.ListOffsetsTopicResponse> topicResponses) {
        return this.buildClientResponse(request, topicResponses, false, null);
    }

    private ClientResponse buildClientResponseWithErrors(NetworkClientDelegate.UnsentRequest request, Map<TopicPartition, Errors> partitionErrors) {
        ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse> topicResponses = new ArrayList<ListOffsetsResponseData.ListOffsetsTopicResponse>();
        partitionErrors.forEach((tp, error) -> topicResponses.add(ListOffsetsResponse.singletonListOffsetsTopicResponse((TopicPartition)tp, (Errors)error, (long)-1L, (long)-1L, (int)-1)));
        return this.buildClientResponse(request, topicResponses, false, null);
    }

    private ClientResponse buildClientResponse(NetworkClientDelegate.UnsentRequest request, List<ListOffsetsResponseData.ListOffsetsTopicResponse> topicResponses, boolean disconnected, AuthenticationException authenticationException) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertInstanceOf(ListOffsetsRequest.class, (Object)abstractRequest);
        ListOffsetsRequest offsetFetchRequest = (ListOffsetsRequest)abstractRequest;
        ListOffsetsResponse response = new ListOffsetsResponse(new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(topicResponses));
        return new ClientResponse(new RequestHeader(ApiKeys.OFFSET_FETCH, offsetFetchRequest.version(), "", 1), (RequestCompletionHandler)request.handler(), "-1", this.time.milliseconds(), this.time.milliseconds(), disconnected, null, authenticationException, (AbstractResponse)response);
    }
}

