/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yubico.internal.util.CertificateParser;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.attestation.AttestationMetadataSource;
import com.yubico.webauthn.attestation.AttestationTrustSource;
import com.yubico.webauthn.attestation.DeviceMatcher;
import com.yubico.webauthn.attestation.MetadataObject;
import com.yubico.webauthn.attestation.matcher.ExtensionMatcher;
import com.yubico.webauthn.attestation.matcher.FingerprintMatcher;
import com.yubico.webauthn.data.ByteArray;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YubicoJsonMetadataService
implements AttestationMetadataSource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(YubicoJsonMetadataService.class);
    private static final String SELECTORS = "selectors";
    private static final String SELECTOR_TYPE = "type";
    private static final String SELECTOR_PARAMETERS = "parameters";
    private static final Map<String, DeviceMatcher> DEFAULT_DEVICE_MATCHERS = Map.of("x509Extension", new ExtensionMatcher(), "fingerprint", new FingerprintMatcher());
    private final Collection<MetadataObject> metadataObjects;
    private final Map<String, DeviceMatcher> matchers;
    private final Set<X509Certificate> trustRootCertificates;

    private YubicoJsonMetadataService(@NonNull Collection<MetadataObject> metadataObjects, @NonNull Map<String, DeviceMatcher> matchers) {
        if (metadataObjects == null) {
            throw new NullPointerException("metadataObjects is marked non-null but is null");
        }
        if (matchers == null) {
            throw new NullPointerException("matchers is marked non-null but is null");
        }
        this.trustRootCertificates = metadataObjects.stream().flatMap(metadataObject -> metadataObject.getTrustedCertificates().stream()).map(pemEncodedCert -> {
            try {
                return CertificateParser.parsePem((String)pemEncodedCert);
            }
            catch (CertificateException e) {
                LOGGER.error("Failed to parse trusted certificate", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        this.metadataObjects = metadataObjects;
        this.matchers = CollectionUtil.immutableMap(matchers);
    }

    public YubicoJsonMetadataService() {
        this(Stream.of(MetadataObject.readDefault(), MetadataObject.readPreview()).collect(Collectors.toList()), DEFAULT_DEVICE_MATCHERS);
    }

    public YubicoJsonMetadataService(@NonNull Collection<MetadataObject> metadataObjects) {
        this(metadataObjects, DEFAULT_DEVICE_MATCHERS);
        if (metadataObjects == null) {
            throw new NullPointerException("metadataObjects is marked non-null but is null");
        }
    }

    @Override
    public Optional<Attestation> findMetadata(X509Certificate attestationCertificate) {
        return this.metadataObjects.stream().map(metadata -> {
            ImmutableMap deviceProperties = null;
            String identifier = metadata.getIdentifier();
            Map vendorProperties = Maps.filterValues(metadata.getVendorInfo(), Objects::nonNull);
            for (JsonNode device : metadata.getDevices()) {
                if (!this.deviceMatches(device.get(SELECTORS), attestationCertificate)) continue;
                ImmutableMap.Builder devicePropertiesBuilder = ImmutableMap.builder();
                for (Map.Entry deviceEntry : Lists.newArrayList((Iterator)device.fields())) {
                    JsonNode value = (JsonNode)deviceEntry.getValue();
                    if (!value.isTextual()) continue;
                    devicePropertiesBuilder.put((Object)((String)deviceEntry.getKey()), (Object)value.asText());
                }
                deviceProperties = devicePropertiesBuilder.build();
                break;
            }
            return Optional.ofNullable(deviceProperties).map(deviceProps -> Attestation.builder().metadataIdentifier(Optional.ofNullable(identifier)).vendorProperties(Optional.of(vendorProperties)).deviceProperties((Map<String, String>)deviceProps).build());
        }).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    private boolean deviceMatches(JsonNode selectors, @NonNull X509Certificate attestationCertificate) {
        if (attestationCertificate == null) {
            throw new NullPointerException("attestationCertificate is marked non-null but is null");
        }
        if (selectors == null || selectors.isNull()) {
            return true;
        }
        for (JsonNode selector : selectors) {
            DeviceMatcher matcher = this.matchers.get(selector.get(SELECTOR_TYPE).asText());
            if (matcher == null || !matcher.matches(attestationCertificate, selector.get(SELECTOR_PARAMETERS))) continue;
            return true;
        }
        return false;
    }

    public AttestationTrustSource.TrustRootsResult findTrustRoots(List<X509Certificate> attestationCertificateChain, Optional<ByteArray> aaguid) {
        return AttestationTrustSource.TrustRootsResult.builder().trustRoots(this.trustRootCertificates).enableRevocationChecking(false).build();
    }
}

