/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.ticket.registry.DefaultTicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.lock.LockRepository;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMatchingHostname;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@EnableAsync(proxyTargetClass=false)
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.TicketRegistry})
@Configuration(value="CasCoreTicketsSchedulingConfiguration", proxyBeanMethods=false)
class CasCoreTicketsSchedulingConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreTicketsSchedulingConfiguration.class);

    CasCoreTicketsSchedulingConfiguration() {
    }

    @ConditionalOnMissingBean(name={"ticketRegistryCleaner"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Lazy(value=false)
    public TicketRegistryCleaner ticketRegistryCleaner(CasConfigurationProperties casProperties, @Qualifier(value="casTicketRegistryLockRepository") LockRepository lockRepository, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
        return new DefaultTicketRegistryCleaner(lockRepository, applicationContext, ticketRegistry);
    }

    @ConditionalOnMissingBean(name={"ticketRegistryCleanerScheduler"})
    @ConditionalOnMatchingHostname(name="cas.ticket.registry.cleaner.schedule.enabled-on-host")
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Lazy(value=false)
    public Runnable ticketRegistryCleanerScheduler(ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistryCleaner") TicketRegistryCleaner ticketRegistryCleaner) {
        return (Runnable)BeanSupplier.of(Runnable.class).when(BeanCondition.on((String)"cas.ticket.registry.cleaner.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            LOGGER.debug("Ticket registry cleaner is enabled to run on schedule.");
            return new TicketRegistryCleanerScheduler(ticketRegistryCleaner);
        }).otherwiseProxy(__ -> LOGGER.info("Ticket registry cleaner is not enabled to run on schedule. Expired tickets are not forcefully cleaned by CAS. It is up to the ticket registry itself to clean up tickets based on its own expiration and eviction policies.")).get();
    }

    static class TicketRegistryCleanerScheduler
    implements Runnable {
        private final TicketRegistryCleaner ticketRegistryCleaner;

        @Override
        @Scheduled(cron="${cas.ticket.registry.cleaner.schedule.cron-expression:}", zone="${cas.ticket.registry.cleaner.schedule.cron-time-zone:}", initialDelayString="${cas.ticket.registry.cleaner.schedule.start-delay:PT30S}", fixedDelayString="${cas.ticket.registry.cleaner.schedule.repeat-interval:PT120S}")
        public void run() {
            FunctionUtils.doAndHandle(__ -> this.ticketRegistryCleaner.clean());
        }

        @Generated
        public TicketRegistryCleanerScheduler(TicketRegistryCleaner ticketRegistryCleaner) {
            this.ticketRegistryCleaner = ticketRegistryCleaner;
        }
    }
}

