/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.NonAuthenticatedStateCommand;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.SaslXoauth2Message;

class AuthenticateCommand
extends NonAuthenticatedStateCommand {
    public static final String NAME = "AUTHENTICATE";
    public static final String ARGS = "<auth_type> *(CRLF base64)";
    public static final String CAPABILITY = "SASL-IR AUTH=XOAUTH2";

    AuthenticateCommand() {
        super(NAME, ARGS);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException {
        String authType = this.parser.astring(request);
        if ("XOAUTH2".equalsIgnoreCase(authType)) {
            String base64 = this.parser.astring(request);
            if ("=".equals(base64)) {
                this.parser.endLine(request);
                base64 = this.parser.astring(request);
            }
            this.parser.endLine(request);
            SaslXoauth2Message xoauth2Message = SaslXoauth2Message.parseBase64Encoded(base64);
            if (session.getUserManager().test(xoauth2Message.getUsername(), xoauth2Message.getAccessToken())) {
                GreenMailUser user = session.getUserManager().getUser(xoauth2Message.getUsername());
                session.setAuthenticated(user);
                response.commandComplete(this);
            } else {
                response.commandFailed(this, "Invalid login/password for user id " + xoauth2Message.getUsername());
            }
        } else {
            this.parser.endLine(request);
            response.commandFailed(this, "Unsupported authentication mechanism '" + authType + "'");
        }
    }
}

