/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.authenticator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCachingAuthenticator
extends InitializableObject
implements Authenticator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalCachingAuthenticator.class);
    private Authenticator delegate;
    private int cacheSize;
    private int timeout;
    private TimeUnit timeUnit;
    private Store<Credentials, UserProfile> store;

    public LocalCachingAuthenticator() {
    }

    public LocalCachingAuthenticator(Authenticator delegate, Store<Credentials, UserProfile> store) {
        this.delegate = delegate;
        this.store = store;
    }

    public LocalCachingAuthenticator(Authenticator delegate, int cacheSize, int timeout, TimeUnit timeUnit) {
        this.delegate = delegate;
        this.cacheSize = cacheSize;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public Optional<Credentials> validate(CallContext ctx, Credentials credentials) {
        this.init();
        Optional<UserProfile> optProfile = this.store.get(credentials);
        if (optProfile.isEmpty()) {
            LOGGER.debug("No cached credentials found. Delegating authentication to {}...", (Object)this.delegate);
            this.delegate.validate(ctx, credentials);
            UserProfile profile = credentials.getUserProfile();
            LOGGER.debug("Caching credential. Using profile {}...", (Object)profile);
            this.store.set(credentials, profile);
        } else {
            credentials.setUserProfile(optProfile.get());
            LOGGER.debug("Found cached credential. Using cached profile {}...", (Object)optProfile.get());
        }
        return Optional.of(credentials);
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        Authenticator authenticator;
        if (this.store == null) {
            this.store = new GuavaStore<Credentials, UserProfile>(this.cacheSize, this.timeout, this.timeUnit);
        }
        if ((authenticator = this.delegate) instanceof InitializableObject) {
            InitializableObject initializableObject = (InitializableObject)((Object)authenticator);
            initializableObject.init(forceReinit);
        }
    }

    public void removeFromCache(Credentials credentials) {
        this.store.remove(credentials);
    }

    public boolean isCached(Credentials credentials) {
        return this.store.get(credentials).isPresent();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Authenticator getDelegate() {
        return this.delegate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getCacheSize() {
        return this.cacheSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Store<Credentials, UserProfile> getStore() {
        return this.store;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDelegate(Authenticator delegate) {
        this.delegate = delegate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStore(Store<Credentials, UserProfile> store) {
        this.store = store;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LocalCachingAuthenticator(delegate=" + this.delegate + ", cacheSize=" + this.cacheSize + ", timeout=" + this.timeout + ", timeUnit=" + this.timeUnit + ", store=" + this.store + ")";
    }
}

