/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CentralMoment
extends Lop {
    private void init(Lop input1, Lop input2, Lop input3, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            definesMRJob = true;
            this.lps.addCompatibility(JobType.CM_COV);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapAndReduce, breaksAlignment, aligner, definesMRJob);
        } else {
            if (input3 != null) {
                this.addInput(input3);
                input3.addOutput(this);
            }
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public CentralMoment(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this(input1, input2, null, dt, vt, et);
    }

    public CentralMoment(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.CentralMoment, dt, vt);
        this.init(input1, input2, input3, et);
    }

    @Override
    public String toString() {
        return "Operation = CentralMoment";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("cm");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        if (input3 != null) {
            sb.append(this.getInputs().get(1).prepInputOperand(input2));
            sb.append("\u00b0");
        }
        sb.append(this.getInputs().get(input3 != null ? 2 : 1).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return this.getInstructions(input1, input2, null, output);
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), "", String.valueOf(output_index));
    }
}

