/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class AppendR
extends Lop {
    public static final String OPCODE = "rappend";
    private boolean _cbind = true;

    public AppendR(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, boolean cbind, LopProperties.ExecType et) {
        super(Lop.Type.Append, dt, vt);
        this.init(input1, input2, dt, vt, et);
        this._cbind = cbind;
    }

    public void init(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return " AppendR: ";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append(this._cbind);
        return sb.toString();
    }
}

