/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CombineBinaryInstruction
extends BinaryMRInstructionBase {
    private boolean secondInputIsWeight = true;

    private CombineBinaryInstruction(Operator op, boolean isWeight, byte in1, byte in2, byte out, String istr) {
        super(MRInstruction.MRType.CombineBinary, op, in1, in2, out);
        this.secondInputIsWeight = isWeight;
        this.instString = istr;
    }

    public static CombineBinaryInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 4);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        boolean isWeight = Boolean.parseBoolean(parts[1]);
        byte in1 = Byte.parseByte(parts[2]);
        byte in2 = Byte.parseByte(parts[3]);
        byte out = Byte.parseByte(parts[4]);
        if (opcode.equalsIgnoreCase("combinebinary")) {
            return new CombineBinaryInstruction(null, isWeight, in1, in2, out, str);
        }
        return null;
    }

    public boolean isSecondInputWeight() {
        return this.secondInputIsWeight;
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) {
        throw new DMLRuntimeException("CombineInstruction.processInstruction should never be called!");
    }
}

