/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CollectMultipleConvertedOutputs;
import org.apache.sysml.runtime.matrix.mapred.MMCJMRCache;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;

public class PartialAggregator
extends MMCJMRCache {
    private long rlen = 0L;
    private long clen = 0L;
    private int brlen = 0;
    private int bclen = 0;
    private long numBlocksInRow = 0L;
    private long numBlocksInColumn = 0L;
    private AggregateBinaryOperator operation;
    private boolean memOnly = false;
    private boolean rowMajor = true;

    public PartialAggregator(JobConf conf, long memSize, long resultRlen, long resultClen, int blockRlen, int blockClen, boolean inRowMajor, AggregateBinaryOperator op, Class<? extends MatrixValue> vCls) throws InstantiationException, IllegalAccessException, IOException {
        this.rlen = resultRlen;
        this.clen = resultClen;
        this.brlen = blockRlen;
        this.bclen = blockClen;
        this.numBlocksInRow = (long)Math.ceil((double)this.clen / (double)this.bclen);
        this.numBlocksInColumn = (long)Math.ceil((double)this.rlen / (double)this.brlen);
        this.operation = op;
        long elementSize = 77L + 8L * Math.min(this.rlen, (long)this.brlen) * Math.min(this.clen, (long)this.bclen) + 20L + 12L + 12L + 4L;
        int buffCapacity = (int)Math.max(Math.min(memSize / elementSize, this.numBlocksInRow * this.numBlocksInColumn), 1L);
        super.allocateBuffer(buffCapacity, vCls, true);
        int n = (int)Math.ceil((double)(this.numBlocksInRow * this.numBlocksInColumn) / (double)this._bufferCapacity);
        boolean bl = this.memOnly = n == 1;
        if (!this.memOnly) {
            this._job = conf;
            this._fs = FileSystem.getLocal(this._job);
            this.rowMajor = inRowMajor;
            this._fileN = n;
            super.constructLocalFilePrefix("_partial_aggregator_");
            super.deleteAllWorkingFiles();
        }
    }

    public void aggregateToBuffer(MatrixIndexes indexes, MatrixValue value, boolean leftcached) throws IOException, DMLRuntimeException {
        if (!this.memOnly) {
            int newFileCursor = this.getFileCursor(indexes);
            if (newFileCursor >= this._fileN) {
                throw new IOException("indexes: " + indexes + " needs to be put in file #" + newFileCursor + " which exceeds the limit: " + this._fileN);
            }
            if (this._fileCursor != newFileCursor) {
                super.writeBuffer();
                this._fileCursor = newFileCursor;
                super.loadBuffer();
            }
        }
        this.aggregateToBufferHelp(indexes, value, leftcached);
    }

    public long outputToHadoop(CollectMultipleConvertedOutputs outputs, int j, Reporter reporter) throws IOException {
        long nonZeros = 0L;
        for (Integer ix : this._bufferMap.values()) {
            outputs.collectOutput((Writable)this._buffer[ix].getKey(), (Writable)this._buffer[ix].getValue(), j, reporter);
            nonZeros += ((MatrixValue)this._buffer[ix].getValue()).getNonZeros();
        }
        if (!this.memOnly) {
            Path path = this.getFilePath(this._fileCursor);
            MapReduceTool.deleteFileIfExistOnHDFS(path, this._job);
        }
        if (!this.memOnly) {
            for (int i = 0; i < this._fileN; ++i) {
                if (i == this._fileCursor) continue;
                Path path = this.getFilePath(i);
                nonZeros += this.copyFileContentAndDelete(path, outputs, j, reporter);
            }
        }
        return nonZeros;
    }

    private void aggregateToBufferHelp(MatrixIndexes indexes, MatrixValue value, boolean leftcached) {
        Integer ix = (Integer)this._bufferMap.get(indexes);
        if (ix != null) {
            ((MatrixValue)this._buffer[ix].getValue()).binaryOperationsInPlace(this.operation.aggOp.increOp, value);
        } else {
            this.addToBuffer(indexes, value);
        }
    }

    private void addToBuffer(MatrixIndexes indexes, MatrixValue value) {
        if (this._bufferSize >= this._buffer.length) {
            throw new RuntimeException("indexes: " + indexes + " needed to be put in postition: " + this._bufferSize + " which exceeds the buffer size: " + this._buffer.length);
        }
        ((MatrixIndexes)this._buffer[this._bufferSize].getKey()).setIndexes(indexes);
        ((MatrixValue)this._buffer[this._bufferSize].getValue()).copy(value);
        this._bufferMap.put(this._buffer[this._bufferSize].getKey(), this._bufferSize);
        ++this._bufferSize;
    }

    private int getFileCursor(MatrixIndexes indexes) {
        if (this.rowMajor) {
            return (int)(((indexes.getRowIndex() - 1L) * this.numBlocksInRow + indexes.getColumnIndex() - 1L) / (long)this._bufferCapacity);
        }
        return (int)(((indexes.getColumnIndex() - 1L) * this.numBlocksInColumn + indexes.getRowIndex() - 1L) / (long)this._bufferCapacity);
    }

    private long copyFileContentAndDelete(Path path, CollectMultipleConvertedOutputs outputs, int j, Reporter reporter) throws IOException {
        long nonZeros = 0L;
        if (this._fs.exists(path)) {
            this._bufferSize = LocalFileUtils.readBlockSequenceFromLocal(path.toString(), this._buffer, this._bufferMap);
            for (int i = 0; i < this._bufferSize; ++i) {
                outputs.collectOutput((Writable)this._buffer[i].getKey(), (Writable)this._buffer[i].getValue(), j, reporter);
                nonZeros += ((MatrixValue)this._buffer[i].getValue()).getNonZeros();
            }
            MapReduceTool.deleteFileIfExistOnHDFS(path, this._job);
        }
        return nonZeros;
    }
}

