/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Iterator;
import java.util.List;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.matrix.data.IJV;

public class ColumnGroupIterator
implements Iterator<IJV> {
    private final int _rl;
    private final int _ru;
    private final int _cgu;
    private final boolean _inclZeros;
    private int _posColGroup = -1;
    private Iterator<IJV> _iterColGroup = null;
    private boolean _noNext = false;
    private List<ColGroup> _colGroups;

    public ColumnGroupIterator(int rl, int ru, int cgl, int cgu, boolean inclZeros, List<ColGroup> colGroups) {
        this._rl = rl;
        this._ru = ru;
        this._cgu = cgu;
        this._inclZeros = inclZeros;
        this._posColGroup = cgl - 1;
        this._colGroups = colGroups;
        this.getNextIterator();
    }

    @Override
    public boolean hasNext() {
        return !this._noNext;
    }

    @Override
    public IJV next() {
        if (this._noNext) {
            throw new RuntimeException("No more entries.");
        }
        IJV ret = this._iterColGroup.next();
        if (!this._iterColGroup.hasNext()) {
            this.getNextIterator();
        }
        return ret;
    }

    private void getNextIterator() {
        while (this._posColGroup + 1 < this._cgu) {
            ++this._posColGroup;
            this._iterColGroup = this._colGroups.get(this._posColGroup).getIterator(this._rl, this._ru, this._inclZeros, false);
            if (!this._iterColGroup.hasNext()) continue;
            return;
        }
        this._noNext = true;
    }
}

