/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public abstract class ColGroupValue
extends ColGroupCompressed
implements Cloneable {
    private static final long serialVersionUID = -6835757655517301955L;
    private static ThreadLocal<Pair<int[], double[]>> memPool = new ThreadLocal<Pair<int[], double[]>>(){

        @Override
        protected Pair<int[], double[]> initialValue() {
            return null;
        }
    };
    private static ThreadLocal<double[]> tmpLeftMultDoubleArray = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return null;
        }
    };
    protected final int _numRows;
    protected boolean _zeros = false;
    protected transient ADictionary _dict;
    private transient SoftReference<int[]> counts;

    protected ColGroupValue(int numRows) {
        this._numRows = numRows;
    }

    protected ColGroupValue(int[] colIndices, int numRows, ADictionary dict) {
        super(colIndices);
        this._numRows = numRows;
        this._dict = dict;
    }

    protected ColGroupValue(int[] colIndices, int numRows, ADictionary dict, int[] cachedCounts) {
        super(colIndices);
        this._numRows = numRows;
        this._dict = dict;
        this.counts = new SoftReference<int[]>(cachedCounts);
    }

    @Override
    public final void decompressToBlock(MatrixBlock target, int rl, int ru, int offT) {
        if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary md = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isEmpty()) {
                return;
            }
            if (mb.isInSparseFormat()) {
                this.decompressToBlockSparseDictionary(target, rl, ru, offT, mb.getSparseBlock());
            } else {
                this.decompressToBlockDenseDictionary(target, rl, ru, offT, mb.getDenseBlockValues());
            }
        } else {
            this.decompressToBlockDenseDictionary(target, rl, ru, offT, this._dict.getValues());
        }
    }

    protected abstract void decompressToBlockSparseDictionary(MatrixBlock var1, int var2, int var3, int var4, SparseBlock var5);

    protected abstract void decompressToBlockDenseDictionary(MatrixBlock var1, int var2, int var3, int var4, double[] var5);

    @Override
    public final int getNumValues() {
        return this._dict.getNumberOfValues(this._colIndexes.length);
    }

    @Override
    public final double[] getValues() {
        return this._dict != null ? this._dict.getValues() : null;
    }

    public final ADictionary getDictionary() {
        return this._dict;
    }

    @Override
    public final MatrixBlock getValuesAsBlock() {
        this._dict = this._dict.getAsMatrixBlockDictionary(this._colIndexes.length);
        MatrixBlock ret = ((MatrixBlockDictionary)this._dict).getMatrixBlock();
        if (this._zeros) {
            MatrixBlock tmp = new MatrixBlock();
            ret.append(new MatrixBlock(1, this._colIndexes.length, 0L), tmp, false);
            return tmp;
        }
        return ret;
    }

    public final int[] getCounts() {
        int[] countsActual = null;
        if (this._dict != null) {
            if (this.counts == null || this.counts.get() == null) {
                countsActual = this.getCounts(new int[this.getNumValues() + (this._zeros ? 1 : 0)]);
                this.counts = new SoftReference<int[]>(countsActual);
            } else {
                countsActual = this.counts.get();
            }
        }
        return countsActual;
    }

    protected final void setCounts(int[] counts) {
        this.counts = new SoftReference<int[]>(counts);
    }

    public final int[] getCachedCounts() {
        return this.counts != null ? this.counts.get() : null;
    }

    public final int[] getCounts(int rl, int ru) {
        int[] tmp = this._zeros ? ColGroupValue.allocIVector(this.getNumValues() + 1, true) : ColGroupValue.allocIVector(this.getNumValues(), true);
        return this.getCounts(rl, ru, tmp);
    }

    public boolean getIfCountsType() {
        return true;
    }

    protected final double sumValues(int valIx, double[] b, double[] dictVals) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        double val = 0.0;
        for (int i = 0; i < numCols; ++i) {
            val += dictVals[valOff + i] * b[this._colIndexes[i]];
        }
        return val;
    }

    protected final double sumValues(int valIx, double[] b, double[] dictVals, int off) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        double val = 0.0;
        for (int i = 0; i < numCols; ++i) {
            val += dictVals[valOff + i] * b[this._colIndexes[i] + off];
        }
        return val;
    }

    private int[] getAggregateColumnsSetDense(double[] b, int cl, int cu, int cut) {
        HashSet<Integer> aggregateColumnsSet = new HashSet<Integer>();
        int retCols = cu - cl;
        for (int k = 0; k < this._colIndexes.length; ++k) {
            int rowIdxOffset = this._colIndexes[k] * cut;
            for (int h = cl; h < cu; ++h) {
                double v = b[rowIdxOffset + h];
                if (v == 0.0) continue;
                aggregateColumnsSet.add(h);
            }
            if (aggregateColumnsSet.size() == retCols) break;
        }
        int[] aggregateColumns = aggregateColumnsSet.stream().mapToInt(x -> x).toArray();
        Arrays.sort(aggregateColumns);
        return aggregateColumns;
    }

    private int[] getAggregateColumnsSetSparse(SparseBlock b, int retCols) {
        HashSet<Integer> aggregateColumnsSet = new HashSet<Integer>();
        for (int h = 0; h < this._colIndexes.length; ++h) {
            int colIdx = this._colIndexes[h];
            if (!b.isEmpty(colIdx)) {
                int[] sIndexes = b.indexes(colIdx);
                for (int i = b.pos(colIdx); i < b.size(colIdx) + b.pos(colIdx); ++i) {
                    aggregateColumnsSet.add(sIndexes[i]);
                }
            }
            if (aggregateColumnsSet.size() == retCols) break;
        }
        int[] aggregateColumns = aggregateColumnsSet.stream().mapToInt(x -> x).toArray();
        Arrays.sort(aggregateColumns);
        return aggregateColumns;
    }

    private double[] preaggValuesFromSparse(int numVals, SparseBlock b, int[] aggregateColumns, int cl, int cu, int cut) {
        double[] ret = new double[numVals * aggregateColumns.length];
        for (int h = 0; h < this._colIndexes.length; ++h) {
            int colIdx = this._colIndexes[h];
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int retIdx = 0;
            for (int i = b.pos(colIdx); i < b.size(colIdx) + b.pos(colIdx); ++i) {
                while (aggregateColumns[retIdx] < sIndexes[i]) {
                    ++retIdx;
                }
                if (sIndexes[i] != aggregateColumns[retIdx]) continue;
                int j = 0;
                int offOrg = h;
                while (j < numVals * aggregateColumns.length) {
                    int n = j + retIdx;
                    ret[n] = ret[n] + this._dict.getValue(offOrg) * sValues[i];
                    j += aggregateColumns.length;
                    offOrg += this._colIndexes.length;
                }
            }
        }
        return ret;
    }

    @Override
    protected final double computeMxx(double c, Builtin builtin) {
        if (this._zeros) {
            c = builtin.execute(c, 0.0);
        }
        if (this._dict != null) {
            return this._dict.aggregate(c, builtin);
        }
        return c;
    }

    @Override
    protected final void computeColMxx(double[] c, Builtin builtin) {
        if (this._zeros) {
            for (int x = 0; x < this._colIndexes.length; ++x) {
                c[this._colIndexes[x]] = builtin.execute(c[this._colIndexes[x]], 0.0);
            }
        }
        if (this._dict != null) {
            this._dict.aggregateCols(c, builtin, this._colIndexes);
        }
    }

    protected final ADictionary applyScalarOp(ScalarOperator op) {
        return this._dict.clone().apply(op);
    }

    protected final ADictionary applyScalarOp(ScalarOperator op, double newVal, int numCols) {
        return this._dict.applyScalarOp(op, newVal, numCols);
    }

    protected final ADictionary applyBinaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        return sparseSafe ? this._dict.clone().applyBinaryRowOp(op, v, sparseSafe, this._colIndexes, left) : this._dict.applyBinaryRowOp(op, v, sparseSafe, this._colIndexes, left);
    }

    public static void setupThreadLocalMemory(int len) {
        if (memPool.get() == null || ((int[])memPool.get().getLeft()).length < len) {
            ImmutablePair p = new ImmutablePair((Object)new int[len], (Object)new double[len]);
            memPool.set((Pair<int[], double[]>)p);
        }
    }

    public static void setupLeftMultThreadLocalMemory(int len) {
        if (tmpLeftMultDoubleArray.get() == null || tmpLeftMultDoubleArray.get().length < len) {
            tmpLeftMultDoubleArray.set(new double[len]);
        }
    }

    public static void cleanupThreadLocalMemory() {
        memPool.remove();
    }

    protected static double[] allocDVector(int len, boolean reset) {
        Pair<int[], double[]> p = memPool.get();
        if (p == null) {
            return new double[len];
        }
        if (((double[])p.getValue()).length < len) {
            ColGroupValue.setupThreadLocalMemory(len);
            return (double[])p.getValue();
        }
        double[] tmp = (double[])p.getValue();
        if (reset) {
            Arrays.fill(tmp, 0, len, 0.0);
        }
        return tmp;
    }

    protected static int[] allocIVector(int len, boolean reset) {
        Pair<int[], double[]> p = memPool.get();
        if (p == null) {
            return new int[len + 1];
        }
        if (((int[])p.getKey()).length < len) {
            ColGroupValue.setupThreadLocalMemory(len);
            return (int[])p.getKey();
        }
        int[] tmp = (int[])p.getKey();
        if (reset) {
            Arrays.fill(tmp, 0, len, 0);
        }
        return tmp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Is Lossy: " + this._dict.isLossy() + " num Rows: " + this.getNumRows() + " contain zero row:" + this._zeros);
        sb.append(super.toString());
        if (this._dict != null) {
            sb.append(String.format("\n%15s ", "Values: " + this._dict.getClass().getSimpleName()));
            sb.append(this._dict.getString(this._colIndexes.length));
        }
        return sb.toString();
    }

    @Override
    public final boolean isLossy() {
        return this._dict.isLossy();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._zeros = in.readBoolean();
        this._dict = DictionaryFactory.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this._zeros);
        this._dict.write(out);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ++ret;
        if (this._dict != null) {
            ret += this._dict.getExactSizeOnDisk();
        }
        return ret;
    }

    public abstract int[] getCounts(int[] var1);

    public abstract int[] getCounts(int var1, int var2, int[] var3);

    @Override
    protected final void computeSum(double[] c, int nRows, boolean square) {
        if (this._dict != null) {
            c[0] = square ? c[0] + this._dict.sumsq(this.getCounts(), this._colIndexes.length) : c[0] + this._dict.sum(this.getCounts(), this._colIndexes.length);
        }
    }

    @Override
    protected final void computeColSums(double[] c, int nRows, boolean square) {
        this._dict.colSum(c, this.getCounts(), this._colIndexes, square);
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        c[0] = c[0] * this._dict.product(this.getCounts(), this._colIndexes.length);
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        this._dict.colProduct(c, this.getCounts(), this._colIndexes);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DMLCompressionException("Error while cloning: " + this.getClass().getSimpleName(), e);
        }
    }

    public AColGroup copyAndSet(double[] newDictionary) {
        return this.copyAndSet(new Dictionary(newDictionary));
    }

    public AColGroup copyAndSet(ADictionary newDictionary) {
        ColGroupValue clone = (ColGroupValue)this.clone();
        clone._dict = newDictionary;
        return clone;
    }

    public AColGroup copyAndSet(int[] colIndexes, double[] newDictionary) {
        return this.copyAndSet(colIndexes, new Dictionary(newDictionary));
    }

    public AColGroup copyAndSet(int[] colIndexes, ADictionary newDictionary) {
        ColGroupValue clone = (ColGroupValue)this.clone();
        clone._dict = newDictionary;
        clone.setColIndices(colIndexes);
        return clone;
    }

    @Override
    public ColGroupValue copy() {
        return (ColGroupValue)this.clone();
    }

    @Override
    protected final AColGroup sliceSingleColumn(int idx) {
        ColGroupValue ret = this.copy();
        ret._colIndexes = new int[]{0};
        if (ret._dict != null) {
            ret._dict = this._colIndexes.length == 1 ? ret._dict.clone() : ret._dict.sliceOutColumnRange(idx, idx + 1, this._colIndexes.length);
        }
        return ret;
    }

    @Override
    protected final AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        ColGroupValue ret = this.copy();
        ret._dict = ret._dict != null ? ret._dict.sliceOutColumnRange(idStart, idEnd, this._colIndexes.length) : null;
        ret._colIndexes = outputCols;
        return ret;
    }

    public static final MatrixBlock allocatePreAggregate(MatrixBlock m, int numVals, int rl, int ru) {
        int lhsRows = ru - rl;
        double[] vals = ColGroupValue.allocDVector(lhsRows * numVals, true);
        DenseBlockFP64 retB = new DenseBlockFP64(new int[]{lhsRows, numVals}, vals);
        MatrixBlock preAgg = new MatrixBlock(lhsRows, numVals, retB);
        return preAgg;
    }

    public abstract void preAggregate(MatrixBlock var1, MatrixBlock var2, int var3, int var4);

    public abstract void preAggregateDense(MatrixBlock var1, MatrixBlock var2, int var3, int var4, int var5, int var6);

    public final Dictionary preAggregateThatIndexStructure(ColGroupValue that, boolean preModify) {
        int outputLength = that._colIndexes.length * this.getNumValues();
        Dictionary ret = new Dictionary(new double[outputLength]);
        if (that instanceof ColGroupDDC) {
            return this.preAggregateThatDDCStructure((ColGroupDDC)that, ret);
        }
        if (that instanceof ColGroupSDC) {
            return this.preAggregateThatSDCStructure((ColGroupSDC)that, ret, preModify);
        }
        if (that instanceof ColGroupSDCSingle) {
            return this.preAggregateThatSDCSingleStructure((ColGroupSDCSingle)that, ret, preModify);
        }
        if (that instanceof ColGroupSDCSingleZeros) {
            return this.preAggregateThatSDCSingleZerosStructure((ColGroupSDCSingleZeros)that, ret);
        }
        if (that instanceof ColGroupSDCZeros) {
            return this.preAggregateThatSDCZerosStructure((ColGroupSDCZeros)that, ret);
        }
        throw new NotImplementedException("Not supported pre aggregate using index structure of :" + that.getClass().getSimpleName() + " in " + this.getClass().getSimpleName());
    }

    protected int getIndexStructureHash() {
        throw new NotImplementedException("This base function should not be called");
    }

    protected Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    @Override
    public final void leftMultByAColGroup(AColGroup lhs, MatrixBlock result) {
        if (lhs instanceof ColGroupEmpty) {
            return;
        }
        if (lhs instanceof ColGroupValue) {
            this.leftMultByColGroupValue((ColGroupValue)lhs, result);
        } else if (lhs instanceof ColGroupUncompressed) {
            this.leftMultByUncompressedColGroup((ColGroupUncompressed)lhs, result);
        } else {
            throw new DMLCompressionException("Not supported left multiplication with A ColGroup of type: " + lhs.getClass().getSimpleName());
        }
    }

    @Override
    public void tsmmAColGroup(AColGroup other, MatrixBlock result) {
        if (other instanceof ColGroupEmpty) {
            return;
        }
        if (other instanceof ColGroupValue) {
            double[] r;
            double[] l;
            boolean left;
            ColGroupValue lg = (ColGroupValue)other;
            boolean bl = left = !this.shouldPreAggregateLeft(other);
            if (left) {
                l = lg._dict.getValues();
                r = this.preAggLeft(lg).getValues();
            } else {
                l = this.preAggRight(lg).getValues();
                r = this._dict.getValues();
            }
            ColGroupValue.matrixMultDictionariesAndOutputToColIndexesDenseDenseUpperTriangle(l, r, lg._colIndexes, this._colIndexes, result);
        } else if (other instanceof ColGroupUncompressed) {
            LOG.warn((Object)"Inefficient multiplication with uncompressed column group");
            ColGroupUncompressed lg = (ColGroupUncompressed)other;
            MatrixBlock otherMBT = LibMatrixReorg.transpose(lg.getData());
            MatrixBlock tmp = new MatrixBlock(otherMBT.getNumRows(), result.getNumColumns(), false);
            tmp.allocateDenseBlock();
            this.leftMultByMatrix(otherMBT, tmp);
            double[] r = tmp.getDenseBlockValues();
            int nCols = result.getNumColumns();
            double[] resV = result.getDenseBlockValues();
            for (int i = 0; i < other._colIndexes.length; ++i) {
                for (int j = 0; j < this._colIndexes.length; ++j) {
                    ColGroupValue.addToUpperTriangle(nCols, this._colIndexes[j], other._colIndexes[i], resV, r[this._colIndexes[j]]);
                }
            }
        } else {
            throw new DMLCompressionException("Unsupported column group type " + other.getClass().getSimpleName());
        }
    }

    private boolean shouldPreAggregateLeft(AColGroup lhs) {
        int lCol;
        double costLeftDense;
        int rCol;
        int nvL = lhs.getNumValues();
        int nvR = this.getNumValues();
        double costRightDense = nvR * (rCol = this._colIndexes.length);
        return costRightDense < (costLeftDense = (double)(nvL * (lCol = lhs._colIndexes.length)));
    }

    private ADictionary preAggLeft(ColGroupValue lhs) {
        return lhs.preAggregateThatIndexStructure(this, false);
    }

    private ADictionary preAggRight(ColGroupValue lhs) {
        return this.preAggregateThatIndexStructure(lhs, false);
    }

    private void leftMultByColGroupValue(ColGroupValue lhs, MatrixBlock result) {
        if (this.sameIndexStructure(lhs)) {
            if (this._dict == lhs._dict) {
                ColGroupValue.tsmmDictionaryWithScaling(this._dict, this.getCounts(), lhs._colIndexes, this._colIndexes, result.getDenseBlockValues(), result.getNumColumns());
            } else {
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexesWithScaling(lhs._dict, this._dict, lhs._colIndexes, this._colIndexes, result, this.getCounts());
            }
        } else if (this.shouldPreAggregateLeft(lhs)) {
            ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(lhs._dict, this.preAggLeft(lhs), lhs._colIndexes, this._colIndexes, result);
        } else {
            ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(this.preAggRight(lhs), this._dict, lhs._colIndexes, this._colIndexes, result);
        }
    }

    private void leftMultByUncompressedColGroup(ColGroupUncompressed lhs, MatrixBlock result) {
        MatrixBlock ucCG = lhs.getData();
        LOG.warn((Object)"Inefficient transpose of uncompressed to fit to template need t(UnCompressedColGroup) %*% AColGroup support");
        MatrixBlock tmp = new MatrixBlock(ucCG.getNumColumns(), ucCG.getNumRows(), ucCG.isInSparseFormat());
        LibMatrixReorg.transpose(ucCG, tmp, InfrastructureAnalyzer.getLocalParallelism());
        this.leftMultByMatrix(tmp, result, lhs._colIndexes);
    }

    @Override
    protected final void tsmm(double[] result, int numColumns, int nRows) {
        int[] counts = this.getCounts();
        ColGroupValue.tsmm(result, numColumns, counts, this._dict, this._colIndexes);
    }

    @Override
    public final boolean containsValue(double pattern) {
        if (pattern == 0.0 && this._zeros) {
            return true;
        }
        return this._dict.containsValue(pattern);
    }

    @Override
    public final long getNumberNonZeros(int nRows) {
        int[] counts = this.getCounts();
        return this._dict.getNumberNonZeros(counts, this._colIndexes.length);
    }

    private static void matrixMultDictionariesAndOutputToColIndexesWithScaling(ADictionary left, ADictionary right, int[] leftRows, int[] rightColumns, MatrixBlock result, int[] counts) {
        boolean modifyRight = right.getInMemorySize() > left.getInMemorySize();
        ADictionary rightM = modifyRight ? right.scaleTuples(counts, rightColumns.length) : right;
        ADictionary leftM = modifyRight ? left : left.scaleTuples(counts, leftRows.length);
        ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(leftM, rightM, leftRows, rightColumns, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tsmmDictionaryWithScaling(ADictionary dict, int[] counts, int[] rows, int[] cols, double[] res, int outCols) {
        if (dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary mbd = (MatrixBlockDictionary)dict;
            MatrixBlock mb = mbd.getMatrixBlock();
            if (mb.isEmpty()) {
                return;
            }
            if (!mb.isInSparseFormat()) throw new NotImplementedException();
            SparseBlock sb = mb.getSparseBlock();
            for (int row = 0; row < sb.numRows(); ++row) {
                if (sb.isEmpty(row)) continue;
                int apos = sb.pos(row);
                int alen = sb.size(row);
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int i = apos; i < apos + alen; ++i) {
                    int offRet = rows[aix[i]] * outCols;
                    double val = avals[i] * (double)counts[row];
                    for (int j = i; j < apos + alen; ++j) {
                        int n = offRet + cols[aix[j]];
                        res[n] = res[n] + val * avals[j];
                    }
                }
            }
            return;
        } else {
            double[] values = dict.getValues();
            for (int row = 0; row < rows.length; ++row) {
                int offTmp = cols.length * row;
                int offRet = outCols * rows[row];
                for (int col = 0; col < cols.length; ++col) {
                    double v = values[offTmp + col] * (double)counts[row];
                    if (v == 0.0) continue;
                    for (int j = col; j < cols.length; ++j) {
                        int n = offRet + cols[col];
                        res[n] = res[n] + v * values[offTmp + j];
                    }
                }
            }
        }
    }

    protected static void matrixMultDictionariesAndOutputToColIndexes(ADictionary left, ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        try {
            double[] leftV = null;
            double[] rightV = null;
            if (left instanceof MatrixBlockDictionary) {
                MatrixBlockDictionary leftD = left.getAsMatrixBlockDictionary(rowsLeft.length);
                MatrixBlock leftMB = leftD.getMatrixBlock();
                if (leftMB.isEmpty()) {
                    return;
                }
                if (right instanceof MatrixBlockDictionary) {
                    MatrixBlockDictionary rightD = right.getAsMatrixBlockDictionary(colsRight.length);
                    MatrixBlock rightMB = rightD.getMatrixBlock();
                    if (rightMB.isEmpty()) {
                        return;
                    }
                    if (rightMB.isInSparseFormat() && leftMB.isInSparseFormat()) {
                        throw new NotImplementedException("Not Supported sparse sparse dictionary multiplication");
                    }
                    if (rightMB.isInSparseFormat()) {
                        ColGroupValue.matrixMultDictionariesAndOutputToColIndecesDenseSparse(leftMB.getDenseBlockValues(), rightMB.getSparseBlock(), rowsLeft, colsRight, result);
                    } else if (leftMB.isInSparseFormat()) {
                        ColGroupValue.matrixMultDictionariesAndOutputToColIndecesSparseDense(leftMB.getSparseBlock(), rightMB.getDenseBlockValues(), rowsLeft, colsRight, result);
                    } else {
                        ColGroupValue.matrixMultDictionariesAndOutputToColIndexesDenseDense(leftMB.getDenseBlockValues(), rightMB.getDenseBlockValues(), rowsLeft, colsRight, result);
                    }
                    return;
                }
                if (leftMB.isInSparseFormat()) {
                    ColGroupValue.matrixMultDictionariesAndOutputToColIndecesSparseDense(leftMB.getSparseBlock(), right.getValues(), rowsLeft, colsRight, result);
                    return;
                }
                leftV = leftMB.getDenseBlockValues();
            } else {
                leftV = left.getValues();
            }
            if (right instanceof MatrixBlockDictionary) {
                MatrixBlockDictionary rightD = right.getAsMatrixBlockDictionary(colsRight.length);
                MatrixBlock rightMB = rightD.getMatrixBlock();
                if (rightMB.isEmpty()) {
                    return;
                }
                if (rightMB.isInSparseFormat()) {
                    ColGroupValue.matrixMultDictionariesAndOutputToColIndecesDenseSparse(leftV, rightMB.getSparseBlock(), rowsLeft, colsRight, result);
                    return;
                }
                rightV = rightMB.getDenseBlockValues();
            } else {
                rightV = right.getValues();
            }
            if (leftV != null && rightV != null) {
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexesDenseDense(leftV, rightV, rowsLeft, colsRight, result);
            }
        }
        catch (Exception e) {
            throw new DMLCompressionException("MM of pre aggregated colGroups failed", e);
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndexesDenseDense(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int offOut = rowsLeft[i] * resCols;
                double vl = left[offL + i];
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offR + j];
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + vl * vr;
                }
            }
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndexesDenseDenseUpperTriangle(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int rowOut = rowsLeft[i];
                double vl = left[offL + i];
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offR + j];
                    int colOut = colsRight[j];
                    ColGroupValue.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndecesSparseDense(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            for (int k = apos; k < alen; ++k) {
                int offOut = rowsLeft[aix[k]] * result.getNumColumns();
                double v = leftVals[k];
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + v * right[offRight + j];
                }
            }
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndecesDenseSparse(double[] left, SparseBlock right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.length, right.numRows());
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.length;
            for (int j = 0; j < rowsLeft.length; ++j) {
                int offOut = rowsLeft[j] * result.getNumColumns();
                double v = left[offLeft + j];
                if (v == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    int n = offOut + colsRight[aix[k]];
                    resV[n] = resV[n] + v * rightVals[k];
                }
            }
        }
    }

    @Override
    public final boolean isDense() {
        return !this._zeros;
    }

    @Override
    public final void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result, int rl, int ru) {
        try {
            int numVals = this.getNumValues();
            MatrixBlock preAgg = ColGroupValue.allocatePreAggregate(matrix, numVals, rl, ru);
            this.preAggregate(matrix, preAgg, rl, ru);
            preAgg.recomputeNonZeros();
            MatrixBlock tmpRes = this.leftMultByPreAggregateMatrix(preAgg);
            this.addMatrixToResult(tmpRes, result, rl, ru);
        }
        catch (Exception e) {
            throw new DMLCompressionException(this.getClass().getSimpleName() + " Failed to Left Matrix Multiply", e);
        }
    }

    public final MatrixBlock leftMultByPreAggregateMatrix(MatrixBlock preAgg) {
        int tmpCol = this._colIndexes.length;
        int tmpRow = preAgg.getNumRows();
        double[] tmpLeftMultRes = tmpLeftMultDoubleArray.get();
        MatrixBlock tmpRes = null;
        if (tmpLeftMultRes != null && tmpLeftMultRes.length >= tmpCol * tmpRow) {
            tmpRes = new MatrixBlock(tmpRow, tmpCol, new DenseBlockFP64(new int[]{tmpRow, tmpCol}, tmpLeftMultRes));
            tmpRes.reset();
        } else {
            tmpRes = new MatrixBlock(tmpRow, tmpCol, false);
        }
        return this.leftMultByPreAggregateMatrix(preAgg, tmpRes);
    }

    public final MatrixBlock leftMultByPreAggregateMatrix(MatrixBlock preAgg, MatrixBlock tmpRes) {
        MatrixBlock dictM = this.forceMatrixBlockDictionary().getMatrixBlock();
        LibMatrixMult.matrixMult(preAgg, dictM, tmpRes);
        return tmpRes;
    }

    private void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result, int[] outputRows) {
        try {
            int numVals = this.getNumValues();
            MatrixBlock preAgg = ColGroupValue.allocatePreAggregate(matrix, numVals, 0, matrix.getNumRows());
            this.preAggregate(matrix, preAgg, 0, matrix.getNumRows());
            preAgg.recomputeNonZeros();
            MatrixBlock tmpRes = this.leftMultByPreAggregateMatrix(preAgg);
            this.addMatrixToResult(tmpRes, result, outputRows);
        }
        catch (Exception e) {
            throw new DMLCompressionException(this.getClass().getSimpleName() + " Failed to multiply with an uncompressed column group", e);
        }
    }

    private MatrixBlockDictionary forceMatrixBlockDictionary() {
        if (!(this._dict instanceof MatrixBlockDictionary)) {
            this._dict = this._dict.getAsMatrixBlockDictionary(this._colIndexes.length);
        }
        return (MatrixBlockDictionary)this._dict;
    }

    public void addMatrixToResult(MatrixBlock tmp, MatrixBlock result, int rl, int ru) {
        if (tmp.isEmpty()) {
            return;
        }
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        if (tmp.isInSparseFormat()) {
            SparseBlock sb = tmp.getSparseBlock();
            int row = rl;
            int offT = 0;
            while (row < ru) {
                int apos = sb.pos(offT);
                int alen = sb.size(offT);
                int[] aix = sb.indexes(offT);
                double[] avals = sb.values(offT);
                int offR = row * nColRet;
                for (int i = apos; i < apos + alen; ++i) {
                    int n = offR + this._colIndexes[aix[i]];
                    retV[n] = retV[n] + avals[i];
                }
                ++row;
                ++offT;
            }
        } else {
            double[] tmpV = tmp.getDenseBlockValues();
            int nCol = this._colIndexes.length;
            int row = rl;
            int offT = 0;
            while (row < ru) {
                int offR = row * nColRet;
                for (int col = 0; col < nCol; ++col) {
                    int n = offR + this._colIndexes[col];
                    retV[n] = retV[n] + tmpV[offT + col];
                }
                ++row;
                offT += nCol;
            }
        }
    }

    private void addMatrixToResult(MatrixBlock tmp, MatrixBlock result, int[] rowIndexes) {
        if (tmp.isEmpty()) {
            return;
        }
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        if (tmp.isInSparseFormat()) {
            SparseBlock sb = tmp.getSparseBlock();
            for (int row = 0; row < rowIndexes.length; ++row) {
                int apos = sb.pos(row);
                int alen = sb.size(row);
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                int offR = rowIndexes[row] * nColRet;
                for (int i = apos; i < apos + alen; ++i) {
                    int n = offR + this._colIndexes[aix[i]];
                    retV[n] = retV[n] + avals[i];
                }
            }
        } else {
            double[] tmpV = tmp.getDenseBlockValues();
            int nCol = this._colIndexes.length;
            int row = 0;
            int offT = 0;
            while (row < rowIndexes.length) {
                int offR = rowIndexes[row] * nColRet;
                for (int col = 0; col < nCol; ++col) {
                    int n = offR + this._colIndexes[col];
                    retV[n] = retV[n] + tmpV[offT + col];
                }
                ++row;
                offT += nCol;
            }
        }
    }

    @Override
    public final AColGroup rightMultByMatrix(MatrixBlock right) {
        if (right.isEmpty()) {
            return null;
        }
        boolean cl = false;
        int cr = right.getNumColumns();
        int numVals = this.getNumValues();
        if (right.isInSparseFormat()) {
            SparseBlock sb = right.getSparseBlock();
            int[] agCols = this.getAggregateColumnsSetSparse(sb, cr);
            if (agCols.length == 0) {
                return null;
            }
            return this.copyAndSet(agCols, this.preaggValuesFromSparse(numVals, sb, agCols, 0, cr, cr));
        }
        double[] rightV = right.getDenseBlockValues();
        int[] agCols = this.getAggregateColumnsSetDense(rightV, 0, cr, cr);
        if (agCols.length == 0) {
            return null;
        }
        ADictionary d = this._dict.preaggValuesFromDense(numVals, this._colIndexes, agCols, rightV, cr);
        if (d == null) {
            return null;
        }
        return this.copyAndSet(agCols, d);
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += 8L;
        size += 8L;
        size += 4L;
        ++size;
        ++size;
        size += 2L;
        return size += this._dict.getInMemorySize();
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.length);
        return this.copyAndSet(replaced);
    }

    public final int getNumRows() {
        return this._numRows;
    }

    protected abstract boolean sameIndexStructure(ColGroupCompressed var1);
}

