/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.HashSet;
import java.util.List;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.Statistics;

public class ColumnEncoderPassThrough
extends ColumnEncoder {
    private static final long serialVersionUID = -8473768154646831882L;

    protected ColumnEncoderPassThrough(int ptCols) {
        super(ptCols);
    }

    public ColumnEncoderPassThrough() {
        this(-1);
    }

    @Override
    public void build(CacheBlock in) {
    }

    @Override
    public List<DependencyTask<?>> getBuildTasks(CacheBlock in) {
        return null;
    }

    @Override
    protected ColumnEncoder.ColumnApplyTask<? extends ColumnEncoder> getSparseTask(CacheBlock in, MatrixBlock out, int outputCol, int startRow, int blk) {
        return new PassThroughSparseApplyTask(this, in, out, outputCol, startRow, blk);
    }

    @Override
    protected double getCode(CacheBlock in, int row) {
        return in.getDoubleNaN(row, this._colID - 1);
    }

    @Override
    protected void applySparse(CacheBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        HashSet<Integer> sparseRowsWZeros = null;
        int index = this._colID - 1;
        for (int r = rowStart; r < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++r) {
            double v = this.getCode(in, r);
            SparseRowVector row = (SparseRowVector)out.getSparseBlock().get(r);
            if (v == 0.0) {
                if (sparseRowsWZeros == null) {
                    sparseRowsWZeros = new HashSet<Integer>();
                }
                sparseRowsWZeros.add(r);
            }
            row.values()[index] = v;
            row.indexes()[index] = outputCol;
        }
        if (sparseRowsWZeros != null) {
            this.addSparseRowsWZeros(sparseRowsWZeros);
        }
    }

    @Override
    protected ColumnEncoder.TransformType getTransformType() {
        return ColumnEncoder.TransformType.PASS_THROUGH;
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderPassThrough) {
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }

    public static class PassThroughSparseApplyTask
    extends ColumnEncoder.ColumnApplyTask<ColumnEncoderPassThrough> {
        protected PassThroughSparseApplyTask(ColumnEncoderPassThrough encoder, CacheBlock input, MatrixBlock out, int outputCol) {
            super(encoder, input, out, outputCol);
        }

        protected PassThroughSparseApplyTask(ColumnEncoderPassThrough encoder, CacheBlock input, MatrixBlock out, int outputCol, int startRow, int blk) {
            super(encoder, input, out, outputCol, startRow, blk);
        }

        @Override
        public Object call() throws Exception {
            if (this._out.getSparseBlock() == null) {
                return null;
            }
            long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            ((ColumnEncoderPassThrough)this._encoder).applySparse(this._input, this._out, this._outputCol, this._startRow, this._blk);
            if (DMLScript.STATISTICS) {
                Statistics.incTransformPassThroughApplyTime(System.nanoTime() - t0);
            }
            return null;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "<ColId: " + ((ColumnEncoderPassThrough)this._encoder)._colID + ">";
        }
    }
}

