/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui;

import java.io.Serializable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.ui.XssSafeRequest;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001E3Aa\u0002\u0005\u0005#!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\t\u0004\u0001\"\u00113\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0005IAE\u000f\u001e9TK\u000e,(/\u001b;z\r&dG/\u001a:\u000b\u0005%Q\u0011AA;j\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012aB:feZdW\r\u001e\u0006\u0002?\u0005)!.\u0019<bq&\u0011\u0011\u0005\b\u0002\u0007\r&dG/\u001a:\u0002\t\r|gN\u001a\t\u0003I\u0015j\u0011AC\u0005\u0003M)\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u0017M,7-\u001e:jifluM\u001d\t\u0003I%J!A\u000b\u0006\u0003\u001fM+7-\u001e:jifl\u0015M\\1hKJ\fa\u0001P5oSRtDcA\u00170aA\u0011a\u0006A\u0007\u0002\u0011!)!e\u0001a\u0001G!)qe\u0001a\u0001Q\u00059A-Z:ue>LH#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\tUs\u0017\u000e^\u0001\u0005S:LG\u000f\u0006\u00024w!)A(\u0002a\u0001{\u000511m\u001c8gS\u001e\u0004\"a\u0007 \n\u0005}b\"\u0001\u0004$jYR,'oQ8oM&<\u0017\u0001\u00033p\r&dG/\u001a:\u0015\tM\u0012u\t\u0014\u0005\u0006\u0007\u001a\u0001\r\u0001R\u0001\u0004e\u0016\f\bCA\u000eF\u0013\t1ED\u0001\bTKJ4H.\u001a;SKF,Xm\u001d;\t\u000b!3\u0001\u0019A%\u0002\u0007I,7\u000f\u0005\u0002\u001c\u0015&\u00111\n\b\u0002\u0010'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\")QJ\u0002a\u0001\u001d\u0006)1\r[1j]B\u00111dT\u0005\u0003!r\u00111BR5mi\u0016\u00148\t[1j]\u0002")
public class HttpSecurityFilter
implements Filter {
    private final SparkConf conf;
    private final SecurityManager securityMgr;

    public void destroy() {
    }

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        Object object = new Object();
        try {
            HttpServletRequest hreq = (HttpServletRequest)req;
            HttpServletResponse hres = (HttpServletResponse)res;
            hres.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            String requestUser = hreq.getRemoteUser();
            String effectiveUser = (String)Option$.MODULE$.apply((Object)hreq.getParameter("doAs")).map((Function1 & Serializable & scala.Serializable)proxy -> {
                String string = requestUser;
                String string2 = proxy;
                if ((string == null ? string2 != null : !string.equals(string2)) && !$this.securityMgr.checkAdminPermissions(requestUser)) {
                    hres.sendError(403, new StringBuilder(43).append("User ").append(requestUser).append(" is not allowed to impersonate others.").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                return proxy;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> requestUser);
            if (!this.securityMgr.checkUIViewPermissions(effectiveUser)) {
                hres.sendError(403, new StringBuilder(44).append("User ").append(effectiveUser).append(" is not authorized to access this page.").toString());
                return;
            }
            String xFrameOptionsValue = (String)this.conf.getOption("spark.ui.allowFramingFrom").map((Function1 & Serializable & scala.Serializable)uri -> new StringBuilder(11).append("ALLOW-FROM ").append((String)uri).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "SAMEORIGIN");
            hres.setHeader("X-Frame-Options", xFrameOptionsValue);
            hres.setHeader("X-XSS-Protection", this.conf.get(UI$.MODULE$.UI_X_XSS_PROTECTION()));
            if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(UI$.MODULE$.UI_X_CONTENT_TYPE_OPTIONS()))) {
                hres.setHeader("X-Content-Type-Options", "nosniff");
            }
            String string = hreq.getScheme();
            String string2 = "https";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                ((Option)this.conf.get(UI$.MODULE$.UI_STRICT_TRANSPORT_SECURITY())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    hres.setHeader("Strict-Transport-Security", x$1);
                    return BoxedUnit.UNIT;
                });
            }
            chain.doFilter((ServletRequest)new XssSafeRequest(hreq, effectiveUser), res);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public HttpSecurityFilter(SparkConf conf, SecurityManager securityMgr) {
        this.conf = conf;
        this.securityMgr = securityMgr;
    }
}

