/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.io.FileFormatProperties;

public class CustomProperties
extends FileFormatProperties
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)CustomProperties.class.getName());
    private static final long serialVersionUID = -4447926749068752721L;
    private String delim;
    private String indexDelim;
    private HashSet<String> naStrings;
    private int firstColIndex;
    private int firstRowIndex;
    private GRPattern rowPattern;
    private GRPattern colPattern;
    private GRSymmetry grSymmetry;

    public CustomProperties() {
    }

    public CustomProperties(GRPattern rowPattern, String delim, HashSet<String> naStrings) {
        this.delim = delim;
        this.naStrings = naStrings;
        this.rowPattern = rowPattern;
        this.colPattern = GRPattern.Regular;
        this.grSymmetry = GRSymmetry.GENERAL;
        this.firstRowIndex = 0;
        this.firstColIndex = 0;
    }

    public CustomProperties(GRPattern rowPattern, String delim, String indexDelim, int firstColIndex) {
        this.delim = delim;
        this.indexDelim = indexDelim;
        this.rowPattern = rowPattern;
        this.colPattern = GRPattern.Irregular;
        this.grSymmetry = GRSymmetry.GENERAL;
        this.firstColIndex = firstColIndex;
        this.firstRowIndex = 0;
    }

    public CustomProperties(GRSymmetry grSymmetry, String delim, int firstRowIndex, int firstColIndex) {
        this.delim = delim;
        this.grSymmetry = grSymmetry;
        this.colPattern = GRPattern.Regular;
        this.rowPattern = GRPattern.Irregular;
        this.firstColIndex = firstColIndex;
        this.firstRowIndex = firstRowIndex;
    }

    public String getDelim() {
        return this.delim;
    }

    public String getIndexDelim() {
        return this.indexDelim;
    }

    public HashSet<String> getNaStrings() {
        return this.naStrings;
    }

    public GRPattern getRowPattern() {
        return this.rowPattern;
    }

    public GRPattern getColPattern() {
        return this.colPattern;
    }

    public GRSymmetry getGrSymmetry() {
        return this.grSymmetry;
    }

    public int getFirstColIndex() {
        return this.firstColIndex;
    }

    public void setFirstColIndex(int firstColIndex) {
        this.firstColIndex = firstColIndex;
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int firstRowIndex) {
        this.firstRowIndex = firstRowIndex;
    }

    protected static enum GRSymmetry {
        GENERAL,
        SYMMETRIC,
        SKEW_SYMMETRIC;


        public String toString() {
            return this.name().toLowerCase().replaceAll("_", "-");
        }
    }

    protected static enum GRPattern {
        Regular,
        Irregular;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

