/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByteNZ;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByteUNZ;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetChar;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetEmpty;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetSingle;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetTwo;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public final class OffsetFactory {
    static final Log LOG = LogFactory.getLog((String)OffsetFactory.class.getName());

    private OffsetFactory() {
    }

    public static AOffset createOffset(int[] indexes) {
        return OffsetFactory.createOffset(indexes, 0, indexes.length);
    }

    public static AOffset createOffset(IntArrayList indexes) {
        return OffsetFactory.createOffset(indexes.extractValues(), 0, indexes.size());
    }

    public static AOffset createOffset(int[] indexes, OFF_TYPE type) {
        return OffsetFactory.createOffset(indexes, 0, indexes.length, type);
    }

    public static AOffset createOffset(int[] indexes, int apos, int alen) {
        try {
            long charSize;
            if (indexes == null) {
                throw new DMLCompressionException("Invalid null indexes input");
            }
            int endLength = alen - apos - 1;
            if (endLength < 0) {
                return new OffsetEmpty();
            }
            if (indexes[0] < 0) {
                throw new DMLCompressionException("Invalid negative offset");
            }
            if (endLength == 0) {
                return new OffsetSingle(indexes[apos]);
            }
            if (endLength == 1) {
                return new OffsetTwo(indexes[apos], indexes[apos + 1]);
            }
            int minValue = indexes[apos];
            int maxValue = indexes[alen - 1];
            int range = maxValue - minValue;
            int correctionByte = OffsetFactory.correctionByte(range, endLength);
            int correctionChar = OffsetFactory.correctionChar(range, endLength);
            long byteSize = OffsetByte.estimateInMemorySize(endLength + correctionByte);
            if (byteSize < (charSize = OffsetChar.estimateInMemorySize(endLength + correctionChar))) {
                return OffsetFactory.createByte(indexes, apos, alen);
            }
            return OffsetFactory.createChar(indexes, apos, alen);
        }
        catch (Exception e) {
            if (indexes == null) {
                throw e;
            }
            for (int i = apos + 1; i < alen; ++i) {
                if (indexes[i] > indexes[i - 1]) continue;
                Object message = "Invalid input to create offset, all values should be continuously increasing.\n";
                message = (String)message + "Index " + (i - 1) + " and Index " + i + " are wrong with values: " + indexes[i - 1] + " and " + indexes[i];
                throw new DMLCompressionException((String)message, e);
            }
            throw new DMLCompressionException("Failed to create offset with input:" + Arrays.toString(indexes) + " Apos: " + apos + " Alen: " + alen, e);
        }
    }

    public static AOffset createOffset(int[] indexes, int apos, int alen, OFF_TYPE type) {
        int indexesLength = alen - apos;
        if (indexesLength <= 0) {
            return new OffsetEmpty();
        }
        if (indexesLength == 1) {
            return new OffsetSingle(indexes[apos]);
        }
        if (indexesLength == 2) {
            return new OffsetTwo(indexes[apos], indexes[apos + 1]);
        }
        if (type == OFF_TYPE.BYTE) {
            return OffsetFactory.createByte(indexes, 0, indexes.length);
        }
        return OffsetFactory.createChar(indexes, 0, indexes.length);
    }

    public static AOffset readIn(DataInput in) throws IOException {
        OFF_TYPE_SPECIALIZATIONS t = OFF_TYPE_SPECIALIZATIONS.values()[in.readByte()];
        switch (t) {
            case EMPTY: {
                return OffsetEmpty.readFields(in);
            }
            case SINGLE_OFFSET: {
                return OffsetSingle.readFields(in);
            }
            case TWO_OFFSET: {
                return OffsetTwo.readFields(in);
            }
            case BYTEUNZ: {
                return OffsetByteUNZ.readFields(in);
            }
            case BYTENZ: {
                return OffsetByteNZ.readFields(in);
            }
            case BYTE: {
                return OffsetByte.readFields(in);
            }
        }
        return OffsetChar.readFields(in);
    }

    public static long estimateInMemorySize(int size, int nRows) {
        if (size == 0) {
            return OffsetEmpty.estimateInMemorySize();
        }
        if (size == 1) {
            return OffsetSingle.estimateInMemorySize();
        }
        if (size == 2) {
            return OffsetTwo.estimateInMemorySize();
        }
        int avgDiff = nRows / size;
        if (avgDiff < 256) {
            int correctionByte = OffsetFactory.correctionByte(nRows, size);
            return OffsetByte.estimateInMemorySize(size - 1 + correctionByte);
        }
        int correctionChar = OffsetFactory.correctionChar(nRows, size);
        return OffsetChar.estimateInMemorySize(size - 1 + correctionChar);
    }

    public static int correctionByte(int nRows, int size) {
        return Math.max(nRows - size * 256, 0) / 256;
    }

    public static int correctionChar(int nRows, int size) {
        return Math.max(nRows - size * 65535, 0) / 65535;
    }

    private static AOffset createByte(int[] indexes, int apos, int alen) {
        int endSize = OffsetFactory.calcSize(indexes, apos, alen, 255);
        int offsetToFirst = indexes[apos];
        int offsetToLast = indexes[alen - 1];
        boolean noZero = endSize == alen - apos - 1;
        byte[] offsets = new byte[endSize];
        int ov = offsetToFirst;
        int p = 0;
        if (noZero) {
            int mp1 = 256;
            for (int i = apos + 1; i < alen; ++i) {
                int nv = indexes[i];
                int offsetSize = nv - ov;
                if (offsetSize <= 0) {
                    throw new DMLCompressionException("invalid offset construction with negative sequences");
                }
                byte mod = (byte)(offsetSize % 256);
                offsets[p++] = mod;
                ov = nv;
            }
        } else {
            int max = -1;
            for (int i = apos + 1; i < alen; ++i) {
                int nv = indexes[i];
                int offsetSize = nv - ov;
                int div = offsetSize / 255;
                byte mod = (byte)(offsetSize % 255);
                if (mod == 0) {
                    p += div - 1;
                    offsets[p++] = -1;
                } else {
                    p += div;
                    offsets[p++] = mod;
                }
                ov = nv;
            }
        }
        boolean noOverHalf = OffsetFactory.getNoOverHalf(offsets);
        return OffsetByte.create(offsets, offsetToFirst, offsetToLast, alen - apos, noZero, noOverHalf);
    }

    private static int calcSize(int[] indexes, int apos, int alen, int offMax) {
        int endSize = 0;
        int ov = indexes[apos];
        for (int i = apos + 1; i < alen; ++i) {
            int nv = indexes[i];
            endSize += 1 + (nv - ov - 1) / offMax;
            ov = nv;
        }
        return endSize;
    }

    private static AOffset createChar(int[] indexes, int apos, int alen) {
        int endSize = OffsetFactory.calcSize(indexes, apos, alen, 65535);
        int offsetToFirst = indexes[apos];
        int offsetToLast = indexes[alen - 1];
        boolean noZero = endSize == alen - apos - 1;
        char[] offsets = new char[endSize];
        int ov = offsetToFirst;
        int p = 0;
        int mp1 = 65536;
        if (noZero) {
            for (int i = apos + 1; i < alen; ++i) {
                int nv = indexes[i];
                int offsetSize = nv - ov;
                if (offsetSize <= 0) {
                    throw new DMLCompressionException("invalid offset construction with negative sequences");
                }
                int mod = offsetSize % 65536;
                offsets[p++] = (char)mod;
                ov = nv;
            }
        } else {
            for (int i = apos + 1; i < alen; ++i) {
                int nv = indexes[i];
                int offsetSize = nv - ov;
                int div = offsetSize / 65535;
                int mod = offsetSize % 65535;
                if (mod == 0) {
                    p += div - 1;
                    offsets[p++] = 65535;
                } else {
                    p += div;
                    offsets[p++] = (char)mod;
                }
                ov = nv;
            }
        }
        return new OffsetChar(offsets, offsetToFirst, offsetToLast, noZero);
    }

    protected static boolean getNoOverHalf(byte[] off) {
        for (byte b : off) {
            if (b >= 1) continue;
            return false;
        }
        return true;
    }

    protected static boolean getNoZero(char[] off) {
        for (char b : off) {
            if (b != '\u0000') continue;
            return false;
        }
        return true;
    }

    public static enum OFF_TYPE_SPECIALIZATIONS {
        BYTE,
        CHAR,
        SINGLE_OFFSET,
        TWO_OFFSET,
        EMPTY,
        BYTEUNZ,
        BYTENZ;

    }

    public static enum OFF_TYPE {
        UBYTE,
        BYTE,
        CHAR;

    }
}

