/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.http.LinkSecurity;
import org.apache.tapestry5.http.services.BaseURLSource;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ContextPathEncoder;

public class LinkImpl
implements Link {
    private Map<String, List<String>> parameters;
    private final String basePath;
    private final boolean forForm;
    private LinkSecurity defaultSecurity;
    private final Response response;
    private final ContextPathEncoder contextPathEncoder;
    private final BaseURLSource baseURLSource;
    private String anchor;

    public LinkImpl(String basePath, boolean forForm, LinkSecurity defaultSecurity, Response response, ContextPathEncoder contextPathEncoder, BaseURLSource baseURLSource) {
        assert (basePath != null);
        this.basePath = basePath;
        this.forForm = forForm;
        this.defaultSecurity = defaultSecurity;
        this.response = response;
        this.contextPathEncoder = contextPathEncoder;
        this.baseURLSource = baseURLSource;
    }

    public Link copyWithBasePath(String basePath) {
        LinkImpl copy = new LinkImpl(basePath, this.forForm, this.defaultSecurity, this.response, this.contextPathEncoder, this.baseURLSource);
        copy.anchor = this.anchor;
        for (String name : this.getParameterNames()) {
            copy.addParameter(name, this.getParameterValues(name));
        }
        return copy;
    }

    private void addParameter(String parameterName, String[] value) {
        assert (InternalUtils.isNonBlank((String)parameterName));
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, List<String>>();
        }
        this.parameters.put(parameterName, Arrays.asList(value));
    }

    public Link addParameter(String parameterName, String value) {
        assert (InternalUtils.isNonBlank((String)parameterName));
        if (this.parameters == null) {
            this.parameters = new TreeMap<String, List<String>>();
        }
        InternalUtils.addToMapList(this.parameters, (Object)parameterName, (Object)(value == null ? "" : value));
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Link removeParameter(String parameterName) {
        assert (InternalUtils.isNonBlank((String)parameterName));
        if (this.parameters != null) {
            this.parameters.remove(parameterName);
        }
        return this;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public List<String> getParameterNames() {
        return InternalUtils.sortedKeys(this.parameters);
    }

    public String getParameterValue(String name) {
        List values = (List)InternalUtils.get(this.parameters, (Object)name);
        return values != null && !values.isEmpty() ? (String)values.get(0) : null;
    }

    public Link setAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public String toAbsoluteURI() {
        return this.buildAnchoredURI(this.defaultSecurity.promote());
    }

    public String toAbsoluteURI(boolean secure) {
        return this.buildAnchoredURI(secure ? LinkSecurity.FORCE_SECURE : LinkSecurity.FORCE_INSECURE);
    }

    public void setSecurity(LinkSecurity newSecurity) {
        assert (newSecurity != null);
        this.defaultSecurity = newSecurity;
    }

    public LinkSecurity getSecurity() {
        return this.defaultSecurity;
    }

    public String toRedirectURI() {
        return this.appendAnchor(this.response.encodeRedirectURL(this.buildURI(this.defaultSecurity)));
    }

    public String toURI() {
        return this.buildAnchoredURI(this.defaultSecurity);
    }

    private String appendAnchor(String path) {
        return InternalUtils.isBlank((String)this.anchor) ? path : path + "#" + this.anchor;
    }

    private String buildAnchoredURI(LinkSecurity security) {
        return this.appendAnchor(this.response.encodeURL(this.buildURI(security)));
    }

    public String toString() {
        return this.toURI();
    }

    private String buildURI(LinkSecurity security) {
        if (!security.isAbsolute() && (this.forForm || this.parameters == null)) {
            return this.basePath;
        }
        StringBuilder builder = new StringBuilder(this.basePath.length() * 2);
        switch (security) {
            case FORCE_SECURE: {
                builder.append(this.baseURLSource.getBaseURL(true));
                break;
            }
            case FORCE_INSECURE: {
                builder.append(this.baseURLSource.getBaseURL(false));
                break;
            }
        }
        builder.append(this.basePath);
        if (!this.forForm) {
            String sep = this.basePath.contains("?") ? "&" : "?";
            for (String name : this.getParameterNames()) {
                List<String> values = this.parameters.get(name);
                for (String value : values) {
                    builder.append(sep);
                    builder.append(name);
                    builder.append('=');
                    builder.append(value);
                    sep = "&";
                }
            }
        }
        return builder.toString();
    }

    public Link addParameterValue(String parameterName, Object value) {
        this.addParameter(parameterName, this.contextPathEncoder.encodeValue(value));
        return this;
    }

    public String[] getParameterValues(String parameterName) {
        List values = (List)InternalUtils.get(this.parameters, (Object)parameterName);
        return values.toArray(new String[values.size()]);
    }
}

