/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.tapestry5.internal.jpa.CommitAfterMethodAdvice;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.apache.tapestry5.jpa.EntityTransactionManager;
import org.apache.tapestry5.jpa.annotations.CommitAfter;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class CommitAfterWorker
implements ComponentClassTransformWorker2 {
    private final Map<String, MethodAdvice> methodAdvices;

    public CommitAfterWorker(EntityManagerManager manager, EntityTransactionManager transactionManager) {
        this.methodAdvices = new HashMap<String, MethodAdvice>(manager.getEntityManagers().size());
        for (Map.Entry<String, EntityManager> entry : manager.getEntityManagers().entrySet()) {
            this.methodAdvices.put(entry.getKey(), new CommitAfterMethodAdvice(transactionManager, entry.getKey()));
        }
        this.methodAdvices.put(null, new CommitAfterMethodAdvice(transactionManager, null));
    }

    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        Iterator iterator = plasticClass.getMethodsWithAnnotation(CommitAfter.class).iterator();
        while (iterator.hasNext()) {
            PlasticMethod method;
            PersistenceContext annotation = (PersistenceContext)(method = (PlasticMethod)iterator.next()).getAnnotation(PersistenceContext.class);
            method.addAdvice(this.methodAdvices.get(annotation == null ? null : annotation.unitName()));
        }
    }
}

