/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.sort.impl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;

public class TezSpillRecord {
    public static final FsPermission SPILL_FILE_PERMS = new FsPermission(416);
    private final ByteBuffer buf;
    private final LongBuffer entries;

    public TezSpillRecord(int numPartitions) {
        this.buf = ByteBuffer.allocate(numPartitions * 24);
        this.entries = this.buf.asLongBuffer();
    }

    public TezSpillRecord(Path indexFileName, Configuration conf) throws IOException {
        this(indexFileName, FileSystem.getLocal((Configuration)conf).getRaw());
    }

    public TezSpillRecord(Path indexFileName, FileSystem fs) throws IOException {
        this(indexFileName, fs, null);
    }

    public TezSpillRecord(Path indexFileName, FileSystem fs, String expectedIndexOwner) throws IOException {
        this(indexFileName, fs, (Checksum)new PureJavaCrc32(), expectedIndexOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TezSpillRecord(Path indexFileName, FileSystem rfs, Checksum crc, String expectedIndexOwner) throws IOException {
        try (FSDataInputStream in = rfs.open(indexFileName);){
            long length = rfs.getFileStatus(indexFileName).getLen();
            int partitions = (int)length / 24;
            int size = partitions * 24;
            this.buf = ByteBuffer.allocate(size);
            if (crc != null) {
                crc.reset();
                CheckedInputStream chk = new CheckedInputStream((InputStream)in, crc);
                IOUtils.readFully((InputStream)chk, (byte[])this.buf.array(), (int)0, (int)size);
                if (chk.getChecksum().getValue() != in.readLong()) {
                    throw new ChecksumException("Checksum error reading spill index: " + indexFileName, -1L);
                }
            } else {
                IOUtils.readFully((InputStream)in, (byte[])this.buf.array(), (int)0, (int)size);
            }
            this.entries = this.buf.asLongBuffer();
        }
    }

    public int size() {
        return this.entries.capacity() / 3;
    }

    public TezIndexRecord getIndex(int partition) {
        int pos = partition * 24 / 8;
        return new TezIndexRecord(this.entries.get(pos), this.entries.get(pos + 1), this.entries.get(pos + 2));
    }

    public void putIndex(TezIndexRecord rec, int partition) {
        int pos = partition * 24 / 8;
        this.entries.put(pos, rec.getStartOffset());
        this.entries.put(pos + 1, rec.getRawLength());
        this.entries.put(pos + 2, rec.getPartLength());
    }

    public void writeToFile(Path loc, Configuration job, FileSystem fs) throws IOException {
        this.writeToFile(loc, job, fs, (Checksum)new PureJavaCrc32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(Path loc, Configuration job, FileSystem rfs, Checksum crc) throws IOException {
        FilterOutputStream chk = null;
        FSDataOutputStream out = rfs.create(loc);
        try {
            if (crc != null) {
                crc.reset();
                chk = new CheckedOutputStream((OutputStream)out, crc);
                chk.write(this.buf.array());
                out.writeLong(((CheckedOutputStream)chk).getChecksum().getValue());
            } else {
                out.write(this.buf.array());
            }
        }
        finally {
            if (chk != null) {
                chk.close();
            } else {
                out.close();
            }
            TezSpillRecord.ensureSpillFilePermissions(loc, rfs);
        }
    }

    public static void ensureSpillFilePermissions(Path loc, FileSystem rfs) throws IOException {
        if (!SPILL_FILE_PERMS.equals((Object)SPILL_FILE_PERMS.applyUMask(FsPermission.getUMask((Configuration)rfs.getConf())))) {
            rfs.setPermission(loc, SPILL_FILE_PERMS);
        }
    }
}

