/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import org.apache.tez.common.counters.AggregateTezCounter;
import org.apache.tez.common.counters.FrameworkCounterGroup;
import org.apache.tez.common.counters.TezCounter;

public class AggregateFrameworkCounter<T extends Enum<T>>
extends FrameworkCounterGroup.FrameworkCounter
implements AggregateTezCounter {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long count = 0L;

    public AggregateFrameworkCounter(Enum<T> ref, String groupName) {
        super(ref, groupName);
    }

    @Override
    public void increment(long incr) {
        throw new IllegalArgumentException("Cannot increment an aggregate counter directly");
    }

    @Override
    public void aggregate(TezCounter other) {
        long othercount;
        long othermin;
        long othermax;
        long val = other.getValue();
        if (other instanceof AggregateTezCounter) {
            othermax = ((AggregateTezCounter)((Object)other)).getMax();
            othermin = ((AggregateTezCounter)((Object)other)).getMin();
            othercount = ((AggregateTezCounter)((Object)other)).getCount();
        } else {
            othermin = othermax = val;
            othercount = 1L;
        }
        this.count += othercount;
        super.increment(val);
        if (this.min == Long.MAX_VALUE) {
            this.min = othermin;
            this.max = othermax;
            return;
        }
        this.min = Math.min(this.min, othermin);
        this.max = Math.max(this.max, othermax);
    }

    @Override
    public long getMin() {
        return this.min;
    }

    @Override
    public long getMax() {
        return this.max;
    }

    public FrameworkCounterGroup.FrameworkCounter<T> asFrameworkCounter() {
        return this;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

